/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.PolicyMetaData;
import com.sun.xacml.Rule;
import com.sun.xacml.Target;
import com.sun.xacml.combine.CombinerParameter;
import com.sun.xacml.combine.RuleCombinerElement;
import com.sun.xacml.combine.RuleCombiningAlgorithm;
import com.sun.xacml.cond.VariableDefinition;
import com.sun.xacml.cond.VariableManager;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Policy
extends AbstractPolicy {
    private Set definitions;

    public Policy(URI id, RuleCombiningAlgorithm combiningAlg, Target target) {
        this(id, null, combiningAlg, null, target, null, null, null);
    }

    public Policy(URI id, RuleCombiningAlgorithm combiningAlg, Target target, List rules) {
        this(id, null, combiningAlg, null, target, null, rules, null);
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, Target target, List rules) {
        this(id, version, combiningAlg, description, target, null, rules, null);
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion, List rules) {
        this(id, version, combiningAlg, description, target, defaultVersion, rules, null);
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion, List rules, Set obligations) {
        this(id, version, combiningAlg, description, target, defaultVersion, rules, obligations, null);
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion, List rules, Set obligations, Set definitions) {
        super(id, version, combiningAlg, description, target, defaultVersion, obligations, null);
        ArrayList<RuleCombinerElement> list = null;
        if (rules != null) {
            list = new ArrayList<RuleCombinerElement>();
            for (Object o : rules) {
                if (!(o instanceof Rule)) {
                    throw new IllegalArgumentException("non-Rule in rules");
                }
                list.add(new RuleCombinerElement((Rule)o));
            }
        }
        this.setChildren(list);
        this.definitions = definitions == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(definitions));
    }

    public Policy(URI id, String version, RuleCombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion, List ruleElements, Set obligations, Set definitions, List parameters) {
        super(id, version, combiningAlg, description, target, defaultVersion, obligations, parameters);
        if (ruleElements != null) {
            for (Object o : ruleElements) {
                if (o instanceof RuleCombinerElement) continue;
                throw new IllegalArgumentException("non-Rule in rules");
            }
        }
        this.setChildren(ruleElements);
        this.definitions = definitions == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(definitions));
    }

    private Policy(Node root) throws ParsingException {
        super(root, "Policy", "RuleCombiningAlgId");
        String id;
        List list;
        ArrayList<Rule> rules = new ArrayList<Rule>();
        HashMap parameters = new HashMap();
        HashMap<String, Node> variableIds = new HashMap<String, Node>();
        PolicyMetaData metaData = this.getMetaData();
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().equals("VariableDefinition")) {
                String id2 = child.getAttributes().getNamedItem("VariableId").getNodeValue();
                if (variableIds.containsKey(id2)) {
                    throw new ParsingException("multiple definitions for variable " + id2);
                }
                variableIds.put(id2, child);
            }
            ++i;
        }
        VariableManager manager = new VariableManager(variableIds, metaData);
        this.definitions = new HashSet();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node child = children.item(i2);
            String name = child.getNodeName();
            if (name.equals("Rule")) {
                rules.add(Rule.getInstance(child, metaData, manager));
            } else if (name.equals("RuleCombinerParameters")) {
                String ref = child.getAttributes().getNamedItem("RuleIdRef").getNodeValue();
                if (parameters.containsKey(ref)) {
                    list = (List)parameters.get(ref);
                    this.parseParameters(list, child);
                } else {
                    list = new ArrayList();
                    this.parseParameters(list, child);
                    parameters.put(ref, list);
                }
            } else if (name.equals("VariableDefinition")) {
                id = child.getAttributes().getNamedItem("VariableId").getNodeValue();
                this.definitions.add(manager.getDefinition(id));
            }
            ++i2;
        }
        this.definitions = Collections.unmodifiableSet(this.definitions);
        ArrayList<RuleCombinerElement> elements = new ArrayList<RuleCombinerElement>();
        for (Rule rule : rules) {
            id = rule.getId().toString();
            list = (ArrayList)parameters.remove(id);
            elements.add(new RuleCombinerElement(rule, list));
        }
        if (!parameters.isEmpty()) {
            throw new ParsingException("Unmatched parameters in Rule");
        }
        this.setChildren(elements);
    }

    private void parseParameters(List parameters, Node root) throws ParsingException {
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("CombinerParameter")) {
                parameters.add(CombinerParameter.getInstance(node));
            }
            ++i;
        }
    }

    public static Policy getInstance(Node root) throws ParsingException {
        if (!root.getNodeName().equals("Policy")) {
            throw new ParsingException("Cannot create Policy from root of type " + root.getNodeName());
        }
        return new Policy(root);
    }

    public Set getVariableDefinitions() {
        return this.definitions;
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        String version;
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(String.valueOf(indent) + "<Policy PolicyId=\"" + this.getId().toString() + "\" RuleCombiningAlgId=\"" + this.getCombiningAlg().getIdentifier().toString() + "\">");
        indenter.in();
        String nextIndent = indenter.makeString();
        String description = this.getDescription();
        if (description != null) {
            out.println(String.valueOf(nextIndent) + "<Description>" + description + "</Description>");
        }
        if ((version = this.getDefaultVersion()) != null) {
            out.println("<PolicyDefaults><XPathVersion>" + version + "</XPathVersion></PolicyDefaults>");
        }
        this.getTarget().encode(output, indenter);
        Iterator it = this.definitions.iterator();
        while (it.hasNext()) {
            ((VariableDefinition)it.next()).encode(output, indenter);
        }
        this.encodeCommonElements(output, indenter);
        indenter.out();
        out.println(String.valueOf(indent) + "</Policy>");
    }
}

