/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.Policy;
import com.sun.xacml.PolicyMetaData;
import com.sun.xacml.PolicyReference;
import com.sun.xacml.Target;
import com.sun.xacml.combine.CombinerParameter;
import com.sun.xacml.combine.PolicyCombinerElement;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.finder.PolicyFinder;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PolicySet
extends AbstractPolicy {
    public PolicySet(URI id, PolicyCombiningAlgorithm combiningAlg, Target target) {
        this(id, null, combiningAlg, null, target, null, null, null);
    }

    public PolicySet(URI id, PolicyCombiningAlgorithm combiningAlg, Target target, List policies) {
        this(id, null, combiningAlg, null, target, policies, null, null);
    }

    public PolicySet(URI id, String version, PolicyCombiningAlgorithm combiningAlg, String description, Target target, List policies) {
        this(id, version, combiningAlg, description, target, policies, null, null);
    }

    public PolicySet(URI id, String version, PolicyCombiningAlgorithm combiningAlg, String description, Target target, List policies, String defaultVersion) {
        this(id, version, combiningAlg, description, target, policies, defaultVersion, null);
    }

    public PolicySet(URI id, String version, PolicyCombiningAlgorithm combiningAlg, String description, Target target, List policies, String defaultVersion, Set obligations) {
        super(id, version, combiningAlg, description, target, defaultVersion, obligations, null);
        ArrayList<PolicyCombinerElement> list = null;
        if (policies != null) {
            list = new ArrayList<PolicyCombinerElement>();
            for (Object o : policies) {
                if (!(o instanceof AbstractPolicy)) {
                    throw new IllegalArgumentException("non-AbstractPolicy in policies");
                }
                list.add(new PolicyCombinerElement((AbstractPolicy)o));
            }
        }
        this.setChildren(list);
    }

    public PolicySet(URI id, String version, PolicyCombiningAlgorithm combiningAlg, String description, Target target, List policyElements, String defaultVersion, Set obligations, List parameters) {
        super(id, version, combiningAlg, description, target, defaultVersion, obligations, parameters);
        if (policyElements != null) {
            for (Object o : policyElements) {
                if (o instanceof PolicyCombinerElement) continue;
                throw new IllegalArgumentException("non-AbstractPolicy in policies");
            }
        }
        this.setChildren(policyElements);
    }

    private PolicySet(Node root, PolicyFinder finder) throws ParsingException {
        super(root, "PolicySet", "PolicyCombiningAlgId");
        ArrayList<AbstractPolicy> policies = new ArrayList<AbstractPolicy>();
        HashMap policyParameters = new HashMap();
        HashMap policySetParameters = new HashMap();
        PolicyMetaData metaData = this.getMetaData();
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("PolicySet")) {
                policies.add(PolicySet.getInstance(child, finder));
            } else if (name.equals("Policy")) {
                policies.add(Policy.getInstance(child));
            } else if (name.equals("PolicySetIdReference")) {
                policies.add(PolicyReference.getInstance(child, finder, metaData));
            } else if (name.equals("PolicyIdReference")) {
                policies.add(PolicyReference.getInstance(child, finder, metaData));
            } else if (name.equals("PolicyCombinerParameters")) {
                this.paramaterHelper(policyParameters, child, "Policy");
            } else if (name.equals("PolicySetCombinerParameters")) {
                this.paramaterHelper(policySetParameters, child, "PolicySet");
            }
            ++i;
        }
        ArrayList<PolicyCombinerElement> elements = new ArrayList<PolicyCombinerElement>();
        for (AbstractPolicy policy : policies) {
            List list = null;
            if (policy instanceof Policy) {
                list = (List)policyParameters.remove(policy.getId().toString());
            } else if (policy instanceof PolicySet) {
                list = (List)policySetParameters.remove(policy.getId().toString());
            } else {
                PolicyReference ref = (PolicyReference)policy;
                String id = ref.getReference().toString();
                list = ref.getReferenceType() == 0 ? (List)policyParameters.remove(id) : (List)policySetParameters.remove(id);
            }
            elements.add(new PolicyCombinerElement(policy, list));
        }
        if (!policyParameters.isEmpty()) {
            throw new ParsingException("Unmatched parameters in Policy");
        }
        if (!policySetParameters.isEmpty()) {
            throw new ParsingException("Unmatched parameters in PolicySet");
        }
        this.setChildren(elements);
    }

    private void paramaterHelper(HashMap parameters, Node root, String prefix) throws ParsingException {
        String ref = root.getAttributes().getNamedItem(String.valueOf(prefix) + "IdRef").getNodeValue();
        if (parameters.containsKey(ref)) {
            List list = (List)parameters.get(ref);
            this.parseParameters(list, root);
        } else {
            ArrayList list = new ArrayList();
            this.parseParameters(list, root);
            parameters.put(ref, list);
        }
    }

    private void parseParameters(List parameters, Node root) throws ParsingException {
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("CombinerParameter")) {
                parameters.add(CombinerParameter.getInstance(node));
            }
            ++i;
        }
    }

    public static PolicySet getInstance(Node root) throws ParsingException {
        return PolicySet.getInstance(root, null);
    }

    public static PolicySet getInstance(Node root, PolicyFinder finder) throws ParsingException {
        if (!root.getNodeName().equals("PolicySet")) {
            throw new ParsingException("Cannot create PolicySet from root of type " + root.getNodeName());
        }
        return new PolicySet(root, finder);
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        String version;
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(String.valueOf(indent) + "<PolicySet PolicySetId=\"" + this.getId().toString() + "\" PolicyCombiningAlgId=\"" + this.getCombiningAlg().getIdentifier().toString() + "\">");
        indenter.in();
        String nextIndent = indenter.makeString();
        String description = this.getDescription();
        if (description != null) {
            out.println(String.valueOf(nextIndent) + "<Description>" + description + "</Description>");
        }
        if ((version = this.getDefaultVersion()) != null) {
            out.println("<PolicySetDefaults><XPathVersion>" + version + "</XPathVersion></PolicySetDefaults>");
        }
        this.getTarget().encode(output, indenter);
        this.encodeCommonElements(output, indenter);
        indenter.out();
        out.println(String.valueOf(indent) + "</PolicySet>");
    }
}

