/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.MatchResult;
import com.sun.xacml.ParsingException;
import com.sun.xacml.PolicyMetaData;
import com.sun.xacml.Target;
import com.sun.xacml.TargetMatch;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetMatchGroup {
    private List matches;
    private int matchType;
    private static final Logger logger = Logger.getLogger(Target.class.getName());

    public TargetMatchGroup(List matchElements, int matchType) {
        this.matches = matchElements == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(new ArrayList(matchElements));
        this.matchType = matchType;
    }

    public static TargetMatchGroup getInstance(Node root, int matchType, PolicyMetaData metaData) throws ParsingException {
        ArrayList<TargetMatch> matches = new ArrayList<TargetMatch>();
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals(String.valueOf(TargetMatch.NAMES[matchType]) + "Match")) {
                matches.add(TargetMatch.getInstance(child, matchType, metaData));
            }
            ++i;
        }
        return new TargetMatchGroup(matches, matchType);
    }

    public MatchResult match(EvaluationCtx context) {
        Iterator it = this.matches.iterator();
        MatchResult result = null;
        while (it.hasNext()) {
            TargetMatch tm = (TargetMatch)it.next();
            result = tm.match(context);
            if (result.getResult() != 0) break;
        }
        return result;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        Iterator it = this.matches.iterator();
        String name = TargetMatch.NAMES[this.matchType];
        out.println(String.valueOf(indent) + "<" + name + ">");
        indenter.in();
        while (it.hasNext()) {
            TargetMatch tm = (TargetMatch)it.next();
            tm.encode(output, indenter);
        }
        out.println(String.valueOf(indent) + "</" + name + ">");
        indenter.out();
    }
}

