/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.MatchResult;
import com.sun.xacml.ParsingException;
import com.sun.xacml.PolicyMetaData;
import com.sun.xacml.TargetMatch;
import com.sun.xacml.TargetMatchGroup;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetSection {
    private List matchGroups;
    private int matchType;
    private int xacmlVersion;

    public TargetSection(List matchGroups, int matchType, int xacmlVersion) {
        this.matchGroups = matchGroups == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(new ArrayList(matchGroups));
        this.matchType = matchType;
        this.xacmlVersion = xacmlVersion;
    }

    public static TargetSection getInstance(Node root, int matchType, PolicyMetaData metaData) throws ParsingException {
        ArrayList<TargetMatchGroup> groups = new ArrayList<TargetMatchGroup>();
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String typeName;
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals(typeName = TargetMatch.NAMES[matchType])) {
                groups.add(TargetMatchGroup.getInstance(child, matchType, metaData));
            } else if (name.equals("Any" + typeName)) break;
            ++i;
        }
        return new TargetSection(groups, matchType, metaData.getXACMLVersion());
    }

    public List getMatchGroups() {
        return this.matchGroups;
    }

    public boolean matchesAny() {
        return this.matchGroups.isEmpty();
    }

    public MatchResult match(EvaluationCtx context) {
        if (this.matchGroups.isEmpty()) {
            return new MatchResult(0);
        }
        Iterator it = this.matchGroups.iterator();
        Status firstIndeterminateStatus = null;
        while (it.hasNext()) {
            TargetMatchGroup group = (TargetMatchGroup)it.next();
            MatchResult result = group.match(context);
            if (result.getResult() == 0) {
                return result;
            }
            if (result.getResult() != 2 || firstIndeterminateStatus != null) continue;
            firstIndeterminateStatus = result.getStatus();
        }
        if (firstIndeterminateStatus == null) {
            return new MatchResult(1);
        }
        return new MatchResult(2, firstIndeterminateStatus);
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        String name = TargetMatch.NAMES[this.matchType];
        if (this.matchGroups.isEmpty()) {
            if (this.xacmlVersion == 0) {
                out.println(String.valueOf(indent) + "<" + name + "s>");
                indenter.in();
                out.println(String.valueOf(indenter.makeString()) + "<Any" + name + "/>");
                indenter.out();
                out.println(String.valueOf(indent) + "</" + name + "s>");
            }
        } else {
            out.println(String.valueOf(indent) + "<" + name + "s>");
            Iterator it = this.matchGroups.iterator();
            indenter.in();
            while (it.hasNext()) {
                TargetMatchGroup group = (TargetMatchGroup)it.next();
                group.encode(output, indenter);
            }
            indenter.out();
            out.println(String.valueOf(indent) + "</" + name + "s>");
        }
    }
}

