/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import java.util.StringTokenizer;

public class VersionConstraints {
    private static final int COMPARE_EQUAL = 0;
    private static final int COMPARE_LESS = 1;
    private static final int COMPARE_GREATER = 2;
    private String version;
    private String earliest;
    private String latest;

    public VersionConstraints(String version, String earliest, String latest) {
        this.version = version;
        this.earliest = earliest;
        this.latest = latest;
    }

    public String getVersionConstraint() {
        return this.version;
    }

    public String getEarliestConstraint() {
        return this.earliest;
    }

    public String getLatestConstraint() {
        return this.latest;
    }

    public boolean meetsConstraint(String version) {
        return VersionConstraints.matches(version, this.version) && VersionConstraints.isEarlier(version, this.latest) && VersionConstraints.isLater(version, this.earliest);
    }

    public static boolean matches(String version, String constraint) {
        return VersionConstraints.compareHelper(version, constraint, 0);
    }

    public static boolean isEarlier(String version, String constraint) {
        return VersionConstraints.compareHelper(version, constraint, 1);
    }

    public static boolean isLater(String version, String constraint) {
        return VersionConstraints.compareHelper(version, constraint, 2);
    }

    private static boolean compareHelper(String version, String constraint, int type) {
        if (constraint == null) {
            return true;
        }
        if (version == null) {
            return true;
        }
        StringTokenizer vtok = new StringTokenizer(version, ".");
        StringTokenizer ctok = new StringTokenizer(constraint, ".");
        while (vtok.hasMoreTokens()) {
            if (!ctok.hasMoreTokens()) {
                return type == 2;
            }
            String c = ctok.nextToken();
            if (c.equals("+")) {
                return true;
            }
            String v = vtok.nextToken();
            if (c.equals("*") || v.equals(c)) continue;
            if (type == 0) {
                return false;
            }
            int cint = Integer.valueOf(c);
            int vint = Integer.valueOf(v);
            if (type == 1) {
                return vint <= cint;
            }
            return vint >= cint;
        }
        if (ctok.hasMoreTokens()) {
            return type == 1;
        }
        return true;
    }
}

