/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.PolicyMetaData;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeDesignator
implements Evaluatable {
    public static final int SUBJECT_TARGET = 0;
    public static final int RESOURCE_TARGET = 1;
    public static final int ACTION_TARGET = 2;
    public static final int ENVIRONMENT_TARGET = 3;
    public static final String SUBJECT_CATEGORY_DEFAULT = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
    private static final String[] targetTypes = new String[]{"Subject", "Resource", "Action", "Environment"};
    private int target;
    private URI type;
    private URI id;
    private URI issuer;
    private boolean mustBePresent;
    private URI subjectCategory;
    private static final Logger logger = Logger.getLogger(AttributeDesignator.class.getName());

    public AttributeDesignator(int target, URI type, URI id, boolean mustBePresent) {
        this(target, type, id, mustBePresent, null);
    }

    public AttributeDesignator(int target, URI type, URI id, boolean mustBePresent, URI issuer) throws IllegalArgumentException {
        if (target != 0 && target != 1 && target != 2 && target != 3) {
            throw new IllegalArgumentException("Input target is not a validvalue");
        }
        this.target = target;
        this.type = type;
        this.id = id;
        this.mustBePresent = mustBePresent;
        this.issuer = issuer;
        this.subjectCategory = null;
    }

    public void setSubjectCategory(URI category) {
        if (this.target == 0) {
            this.subjectCategory = category;
        }
    }

    public static AttributeDesignator getInstance(Node root, int target) throws ParsingException {
        return AttributeDesignator.getInstance(root, target, new PolicyMetaData());
    }

    public static AttributeDesignator getInstance(Node root, int target, PolicyMetaData metaData) throws ParsingException {
        URI type = null;
        URI id = null;
        URI issuer = null;
        boolean mustBePresent = false;
        URI subjectCategory = null;
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Required AttributeId missing in AttributeDesignator", e);
        }
        try {
            type = new URI(attrs.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Required DataType missing in AttributeDesignator", e);
        }
        try {
            Node node = attrs.getNamedItem("Issuer");
            if (node != null) {
                issuer = new URI(node.getNodeValue());
            }
            if (target == 0) {
                Node scnode = attrs.getNamedItem("SubjectCategory");
                subjectCategory = scnode != null ? new URI(scnode.getNodeValue()) : new URI(SUBJECT_CATEGORY_DEFAULT);
            }
            if ((node = attrs.getNamedItem("MustBePresent")) != null && node.getNodeValue().equals("true")) {
                mustBePresent = true;
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing AttributeDesignator optional attributes", e);
        }
        AttributeDesignator ad = new AttributeDesignator(target, type, id, mustBePresent, issuer);
        ad.setSubjectCategory(subjectCategory);
        return ad;
    }

    public int getDesignatorType() {
        return this.target;
    }

    @Override
    public URI getType() {
        return this.type;
    }

    public URI getId() {
        return this.id;
    }

    public URI getCategory() {
        return this.subjectCategory;
    }

    public URI getIssuer() {
        return this.issuer;
    }

    public boolean mustBePresent() {
        return this.mustBePresent;
    }

    @Override
    public boolean returnsBag() {
        return true;
    }

    @Override
    public boolean evaluatesToBag() {
        return true;
    }

    @Override
    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public EvaluationResult evaluate(EvaluationCtx context) {
        EvaluationResult result = null;
        switch (this.target) {
            case 0: {
                result = context.getSubjectAttribute(this.type, this.id, this.issuer, this.subjectCategory);
                break;
            }
            case 1: {
                result = context.getResourceAttribute(this.type, this.id, this.issuer);
                break;
            }
            case 2: {
                result = context.getActionAttribute(this.type, this.id, this.issuer);
                break;
            }
            case 3: {
                result = context.getEnvironmentAttribute(this.type, this.id, this.issuer);
            }
        }
        if (result.indeterminate()) {
            return result;
        }
        BagAttribute bag = (BagAttribute)result.getAttributeValue();
        if (bag.isEmpty() && this.mustBePresent) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("AttributeDesignator failed to resolve a value for a required attribute: " + this.id.toString());
            }
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
            String message = "Couldn't find " + targetTypes[this.target] + "AttributeDesignator attribute";
            return new EvaluationResult(new Status(code, message));
        }
        return result;
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        String tag = "<" + targetTypes[this.target] + "AttributeDesignator";
        if (this.target == 0 && this.subjectCategory != null) {
            tag = String.valueOf(tag) + " SubjectCategory=\"" + this.subjectCategory.toString() + "\"";
        }
        tag = String.valueOf(tag) + " AttributeId=\"" + this.id.toString() + "\"";
        tag = String.valueOf(tag) + " DataType=\"" + this.type.toString() + "\"";
        if (this.issuer != null) {
            tag = String.valueOf(tag) + " Issuer=\"" + this.issuer.toString() + "\"";
        }
        if (this.mustBePresent) {
            tag = String.valueOf(tag) + " MustBePresent=\"true\"";
        }
        tag = String.valueOf(tag) + "/>";
        out.println(String.valueOf(indent) + tag);
    }
}

