/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.PolicyMetaData;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeSelector
implements Evaluatable {
    private URI type;
    private String contextPath;
    private boolean mustBePresent;
    private String xpathVersion;
    private Node policyRoot;
    private static final Logger logger = Logger.getLogger(AttributeSelector.class.getName());

    public AttributeSelector(URI type, String contextPath, boolean mustBePresent, String xpathVersion) {
        this(type, contextPath, null, mustBePresent, xpathVersion);
    }

    public AttributeSelector(URI type, String contextPath, Node policyRoot, boolean mustBePresent, String xpathVersion) {
        this.type = type;
        this.contextPath = contextPath;
        this.mustBePresent = mustBePresent;
        this.xpathVersion = xpathVersion;
        this.policyRoot = policyRoot;
    }

    public static AttributeSelector getInstance(Node root, String xpathVersion) throws ParsingException {
        return AttributeSelector.getInstance(root, new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion));
    }

    public static AttributeSelector getInstance(Node root, PolicyMetaData metaData) throws ParsingException {
        URI type = null;
        String contextPath = null;
        boolean mustBePresent = false;
        String xpathVersion = metaData.getXPathIdentifier();
        if (xpathVersion == null) {
            throw new ParsingException("An XPathVersion is required for any policies that use selectors");
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            type = new URI(attrs.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required DataType attribute in AttributeSelector", e);
        }
        try {
            contextPath = attrs.getNamedItem("RequestContextPath").getNodeValue();
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required RequestContextPath attribute in AttributeSelector", e);
        }
        try {
            Node node = attrs.getNamedItem("MustBePresent");
            if (node != null && node.getNodeValue().equals("true")) {
                mustBePresent = true;
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional attributes in AttributeSelector", e);
        }
        Node policyRoot = null;
        Node node = root.getParentNode();
        while (node != null && node.getNodeType() == 1) {
            policyRoot = node;
            node = node.getParentNode();
        }
        return new AttributeSelector(type, contextPath, policyRoot, mustBePresent, xpathVersion);
    }

    @Override
    public URI getType() {
        return this.type;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean mustBePresent() {
        return this.mustBePresent;
    }

    @Override
    public boolean returnsBag() {
        return true;
    }

    @Override
    public boolean evaluatesToBag() {
        return true;
    }

    @Override
    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public String getXPathVersion() {
        return this.xpathVersion;
    }

    @Override
    public EvaluationResult evaluate(EvaluationCtx context) {
        EvaluationResult result = context.getAttribute(this.contextPath, this.policyRoot, this.type, this.xpathVersion);
        if (!result.indeterminate()) {
            BagAttribute bag = (BagAttribute)result.getAttributeValue();
            if (bag.isEmpty()) {
                if (this.mustBePresent) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("AttributeSelector failed to resolve a value for a required attribute: " + this.contextPath);
                    }
                    ArrayList<String> code = new ArrayList<String>();
                    code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
                    String message = "couldn't resolve XPath expression " + this.contextPath + " for type " + this.type.toString();
                    return new EvaluationResult(new Status(code, message));
                }
                return result;
            }
            return result;
        }
        return result;
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        String tag = "<AttributeSelector RequestContextPath=\"" + this.contextPath + "\" DataType=\"" + this.type.toString() + "\"";
        if (this.mustBePresent) {
            tag = String.valueOf(tag) + " MustBePresent=\"true\"";
        }
        tag = String.valueOf(tag) + "/>";
        out.println(String.valueOf(indent) + tag);
    }
}

