/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.Base64;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.w3c.dom.Node;

public class Base64BinaryAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#base64Binary";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private byte[] value;
    private String strValue;

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }

    public Base64BinaryAttribute(byte[] value) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = (byte[])value.clone();
    }

    public static Base64BinaryAttribute getInstance(Node root) throws ParsingException {
        return Base64BinaryAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static Base64BinaryAttribute getInstance(String value) throws ParsingException {
        byte[] bytes = null;
        try {
            bytes = Base64.decode(value, false);
        }
        catch (IOException e) {
            throw new ParsingException("Couldn't parse purported Base64 string: " + value, e);
        }
        return new Base64BinaryAttribute(bytes);
    }

    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Base64BinaryAttribute)) {
            return false;
        }
        Base64BinaryAttribute other = (Base64BinaryAttribute)o;
        return Arrays.equals(this.value, other.value);
    }

    public int hashCode() {
        int code = this.value[0];
        int i = 1;
        while (i < this.value.length) {
            code *= 31;
            code += this.value[i];
            ++i;
        }
        return code;
    }

    private String makeStringRep() {
        return Base64.encode(this.value);
    }

    public String toString() {
        if (this.strValue == null) {
            this.strValue = this.makeStringRep();
        }
        return "Base64BinaryAttribute: [\n" + this.strValue + "]\n";
    }

    @Override
    public String encode() {
        if (this.strValue == null) {
            this.strValue = this.makeStringRep();
        }
        return this.strValue;
    }
}

