/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import org.w3c.dom.Node;

public class BooleanAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#boolean";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private static BooleanAttribute trueInstance;
    private static BooleanAttribute falseInstance;
    private boolean value;

    static {
        try {
            identifierURI = new URI(identifier);
            trueInstance = new BooleanAttribute(true);
            falseInstance = new BooleanAttribute(false);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }

    private BooleanAttribute(boolean value) {
        super(identifierURI);
        this.value = value;
    }

    public static BooleanAttribute getInstance(Node root) throws ParsingException {
        return BooleanAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static BooleanAttribute getInstance(String value) throws ParsingException {
        if (earlyException != null) {
            throw earlyException;
        }
        if (value.equals("true")) {
            return trueInstance;
        }
        if (value.equals("false")) {
            return falseInstance;
        }
        throw new ParsingException("Boolean string must be true or false");
    }

    public static BooleanAttribute getInstance(boolean value) {
        if (earlyException != null) {
            throw earlyException;
        }
        if (value) {
            return trueInstance;
        }
        return falseInstance;
    }

    public static BooleanAttribute getTrueInstance() {
        if (earlyException != null) {
            throw earlyException;
        }
        return trueInstance;
    }

    public static BooleanAttribute getFalseInstance() {
        if (earlyException != null) {
            throw earlyException;
        }
        return falseInstance;
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BooleanAttribute)) {
            return false;
        }
        BooleanAttribute other = (BooleanAttribute)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return this.value ? 1231 : 1237;
    }

    @Override
    public String encode() {
        return this.value ? "true" : "false";
    }
}

