/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DateAttribute;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Node;

public class DateTimeAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#dateTime";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private static DateFormat simpleParser;
    private static DateFormat zoneParser;
    private static Calendar gmtCalendar;
    public static final int TZ_UNSPECIFIED = -1000000;
    private Date value;
    private int nanoseconds;
    private int timeZone;
    private int defaultedTimeZone;
    private String encodedValue = null;

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }

    public DateTimeAttribute() {
        this(new Date());
    }

    public DateTimeAttribute(Date dateTime) {
        super(identifierURI);
        int currOffset = DateTimeAttribute.getDefaultTZOffset(dateTime);
        this.init(dateTime, 0, currOffset, currOffset);
    }

    public DateTimeAttribute(Date dateTime, int nanoseconds, int timeZone, int defaultedTimeZone) {
        super(identifierURI);
        this.init(dateTime, nanoseconds, timeZone, defaultedTimeZone);
    }

    private void init(Date date, int nanoseconds, int timeZone, int defaultedTimeZone) {
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = (Date)date.clone();
        this.nanoseconds = DateTimeAttribute.combineNanos(this.value, nanoseconds);
        this.timeZone = timeZone;
        this.defaultedTimeZone = defaultedTimeZone;
    }

    public static DateTimeAttribute getInstance(Node root) throws ParsingException, NumberFormatException, ParseException {
        return DateTimeAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static DateTimeAttribute getInstance(String value) throws ParsingException, NumberFormatException, ParseException {
        int defaultedTimeZone;
        int timeZone;
        Date gmtValue;
        int len;
        Date dateValue = null;
        int nanoseconds = 0;
        DateTimeAttribute.initParsers();
        if (value.endsWith("Z")) {
            value = String.valueOf(value.substring(0, value.length() - 1)) + "+00:00";
        }
        boolean hasTimeZone = value.charAt((len = value.length()) - 3) == ':' && (value.charAt(len - 6) == '-' || value.charAt(len - 6) == '+');
        int dotIndex = value.indexOf(46);
        if (dotIndex != -1) {
            int secondsEnd = value.length();
            if (hasTimeZone) {
                secondsEnd -= 6;
            }
            String nanoString = value.substring(dotIndex + 1, secondsEnd);
            int i = nanoString.length() - 1;
            while (i >= 0) {
                char c = nanoString.charAt(i);
                if (c < '0' || c > '9') {
                    throw new ParsingException("non-ascii digit found");
                }
                --i;
            }
            while (nanoString.length() < 9) {
                nanoString = String.valueOf(nanoString) + "0";
            }
            if (nanoString.length() > 9) {
                nanoString = nanoString.substring(0, 9);
            }
            nanoseconds = Integer.parseInt(nanoString);
            value = String.valueOf(value.substring(0, dotIndex)) + value.substring(secondsEnd, value.length());
        }
        if (hasTimeZone) {
            len = value.length();
            gmtValue = DateTimeAttribute.strictParse(zoneParser, String.valueOf(value.substring(0, len - 6)) + "+0000");
            value = String.valueOf(value.substring(0, len - 3)) + value.substring(len - 2, len);
            dateValue = DateTimeAttribute.strictParse(zoneParser, value);
            timeZone = (int)(gmtValue.getTime() - dateValue.getTime());
            defaultedTimeZone = timeZone /= 60000;
        } else {
            dateValue = DateTimeAttribute.strictParse(simpleParser, value);
            timeZone = -1000000;
            gmtValue = DateTimeAttribute.strictParse(zoneParser, String.valueOf(value) + "+0000");
            defaultedTimeZone = (int)(gmtValue.getTime() - dateValue.getTime());
            defaultedTimeZone /= 60000;
        }
        DateTimeAttribute attr = new DateTimeAttribute(dateValue, nanoseconds, timeZone, defaultedTimeZone);
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date strictParse(DateFormat parser, String str) throws ParseException {
        Date ret;
        ParsePosition pos = new ParsePosition(0);
        DateFormat dateFormat = parser;
        synchronized (dateFormat) {
            ret = parser.parse(str, pos);
        }
        if (pos.getIndex() != str.length()) {
            throw new ParseException("", 0);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initParsers() {
        if (simpleParser != null) {
            return;
        }
        if (earlyException != null) {
            throw earlyException;
        }
        URI uRI = identifierURI;
        synchronized (uRI) {
            simpleParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            simpleParser.setLenient(false);
            zoneParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            zoneParser.setLenient(false);
        }
    }

    public Date getValue() {
        return (Date)this.value.clone();
    }

    public int getNanoseconds() {
        return this.nanoseconds;
    }

    public int getTimeZone() {
        return this.timeZone;
    }

    public int getDefaultedTimeZone() {
        return this.defaultedTimeZone;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateTimeAttribute)) {
            return false;
        }
        DateTimeAttribute other = (DateTimeAttribute)o;
        return this.value.equals(other.value) && this.nanoseconds == other.nanoseconds;
    }

    public int hashCode() {
        int hashCode = this.value.hashCode();
        hashCode = 31 * hashCode + this.nanoseconds;
        return hashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DateTimeAttribute: [\n");
        sb.append("  Date: " + this.value + " local time");
        sb.append("  Nanoseconds: " + this.nanoseconds);
        sb.append("  TimeZone: " + this.timeZone);
        sb.append("  Defaulted TimeZone: " + this.defaultedTimeZone);
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encode() {
        if (this.encodedValue != null) {
            return this.encodedValue;
        }
        if (this.timeZone == -1000000) {
            DateTimeAttribute.initParsers();
            DateFormat dateFormat = simpleParser;
            synchronized (dateFormat) {
                this.encodedValue = simpleParser.format(this.value);
            }
            if (this.nanoseconds != 0) {
                this.encodedValue = String.valueOf(this.encodedValue) + "." + DateAttribute.zeroPadInt(this.nanoseconds, 9);
            }
        } else {
            this.encodedValue = this.formatDateTimeWithTZ();
        }
        return this.encodedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDateTimeWithTZ() {
        if (gmtCalendar == null) {
            TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
            gmtCalendar = Calendar.getInstance(gmtTimeZone, Locale.US);
        }
        StringBuffer buf = new StringBuffer(35);
        Calendar calendar = gmtCalendar;
        synchronized (calendar) {
            gmtCalendar.setTime(this.value);
            gmtCalendar.add(12, this.timeZone);
            int year = gmtCalendar.get(1);
            buf.append(DateAttribute.zeroPadInt(year, 4));
            buf.append('-');
            int month = gmtCalendar.get(2) + 1;
            buf.append(DateAttribute.zeroPadInt(month, 2));
            buf.append('-');
            int dom = gmtCalendar.get(5);
            buf.append(DateAttribute.zeroPadInt(dom, 2));
            buf.append('T');
            int hour = gmtCalendar.get(11);
            buf.append(DateAttribute.zeroPadInt(hour, 2));
            buf.append(':');
            int minute = gmtCalendar.get(12);
            buf.append(DateAttribute.zeroPadInt(minute, 2));
            buf.append(':');
            int second = gmtCalendar.get(13);
            buf.append(DateAttribute.zeroPadInt(second, 2));
        }
        if (this.nanoseconds != 0) {
            buf.append('.');
            buf.append(DateAttribute.zeroPadInt(this.nanoseconds, 9));
        }
        int tzNoSign = this.timeZone;
        if (this.timeZone < 0) {
            tzNoSign = -tzNoSign;
            buf.append('-');
        } else {
            buf.append('+');
        }
        int tzHours = tzNoSign / 60;
        buf.append(DateAttribute.zeroPadInt(tzHours, 2));
        buf.append(':');
        int tzMinutes = tzNoSign % 60;
        buf.append(DateAttribute.zeroPadInt(tzMinutes, 2));
        return buf.toString();
    }

    static int getDefaultTZOffset(Date date) {
        int offset = TimeZone.getDefault().getOffset(date.getTime());
        return offset /= 60000;
    }

    static int combineNanos(Date date, int nanoseconds) {
        long millis = date.getTime();
        int milliCarry = (int)(millis % 1000L);
        if (milliCarry == 0 && nanoseconds > 0 && nanoseconds < 1000000000) {
            return nanoseconds;
        }
        millis -= (long)milliCarry;
        long nanoTemp = nanoseconds;
        int nanoResult = (int)((nanoTemp += (long)(milliCarry * 1000000)) % 1000000000L);
        date.setTime(millis += (nanoTemp -= (long)nanoResult) / 1000000L);
        return nanoResult;
    }
}

