/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import org.w3c.dom.Node;

public class DoubleAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#double";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private double value;

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }

    public DoubleAttribute(double value) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = value;
    }

    public static DoubleAttribute getInstance(Node root) throws NumberFormatException {
        return DoubleAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static DoubleAttribute getInstance(String value) {
        if (value.endsWith("INF")) {
            int infIndex = value.lastIndexOf("INF");
            value = String.valueOf(value.substring(0, infIndex)) + "Infinity";
        }
        return new DoubleAttribute(Double.parseDouble(value));
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DoubleAttribute)) {
            return false;
        }
        DoubleAttribute other = (DoubleAttribute)o;
        if (Double.isNaN(this.value)) {
            return Double.isNaN(other.value);
        }
        return this.value == other.value;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    @Override
    public String encode() {
        return String.valueOf(this.value);
    }
}

