/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.GeometryAttribute;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GeometryLineStringAttribute
extends GeometryAttribute {
    private final String type = "http://www.opengis.net/gml#LineString";

    public GeometryLineStringAttribute(GeometryFactory gFactory, CoordinateArraySequence v) {
        LineString newLineString = gFactory.createLineString((CoordinateSequence)v);
        this.setGeometry((Geometry)newLineString);
    }

    public int numPoints() {
        return ((LineString)this.getGeometry()).getNumPoints();
    }

    public Point pointN(int index) {
        return ((LineString)this.getGeometry()).getPointN(index);
    }

    public Point startPoint() {
        return ((LineString)this.getGeometry()).getStartPoint();
    }

    public Point endPoint() {
        return ((LineString)this.getGeometry()).getEndPoint();
    }

    public double length() {
        return ((LineString)this.getGeometry()).getLength();
    }

    public boolean isClosed() {
        return ((LineString)this.getGeometry()).isClosed();
    }

    public boolean isRing() {
        return ((LineString)this.getGeometry()).isRing();
    }

    public static GeometryLineStringAttribute getInstance(CoordinateArraySequence v, GeometryFactory gFactory) {
        return new GeometryLineStringAttribute(gFactory, v);
    }

    public static GeometryLineStringAttribute getInstance(Node root, GeometryFactory gFactory) {
        GeometryLineStringAttribute newInstance = null;
        NodeList childes = root.getChildNodes();
        int i = 0;
        while (i < childes.getLength()) {
            Node child = childes.item(i);
            String tag = child.getNodeName();
            if (tag.contains("coordinates") || tag.contains("posList")) {
                String[] coords;
                String dirtyValue = child.getFirstChild().getNodeValue();
                String value = dirtyValue.replace("\n", " ");
                value = value.trim();
                value = value.replaceAll("\\s\\s+", " ");
                ArrayList<Coordinate> points = new ArrayList<Coordinate>();
                if (tag.contains("coordinates")) {
                    value = value.replaceAll("\\s,", ",");
                    value = value.replaceAll(",\\s", ",");
                    coords = value.split(" ");
                    int j = 0;
                    while (j < coords.length) {
                        String[] coord = coords[j].split(",");
                        if (coord.length == 2) {
                            points.add(new Coordinate(Double.parseDouble(coord[0]), Double.parseDouble(coord[1])));
                        } else if (coord.length == 3) {
                            points.add(new Coordinate(Double.parseDouble(coord[0]), Double.parseDouble(coord[1]), Double.parseDouble(coord[2])));
                        }
                        ++j;
                    }
                } else {
                    Node dimAttr = child.getAttributes().getNamedItem("dimension");
                    int dimension = Integer.parseInt(dimAttr.getNodeValue());
                    String[] coords2 = value.split(" ");
                    int j = 0;
                    while (j < coords2.length) {
                        if (dimension == 2) {
                            points.add(new Coordinate(Double.parseDouble(coords2[j]), Double.parseDouble(coords2[j + 1])));
                        } else if (dimension == 3) {
                            points.add(new Coordinate(Double.parseDouble(coords2[j]), Double.parseDouble(coords2[j + 1]), Double.parseDouble(coords2[j + 2])));
                        }
                        j += dimension;
                    }
                }
                coords = points.toArray(new Coordinate[points.size()]);
                newInstance = GeometryLineStringAttribute.getInstance(new CoordinateArraySequence((Coordinate[])coords), gFactory);
            }
            ++i;
        }
        return newInstance;
    }

    @Override
    public String geometryType() {
        return "http://www.opengis.net/gml#LineString";
    }

    @Override
    public String encode() {
        return null;
    }
}

