/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.GeometryAttribute;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GeometryPointAttribute
extends GeometryAttribute {
    private final String type = "http://www.opengis.net/gml#Point";
    private Double measure = null;

    public GeometryPointAttribute(GeometryFactory gFactory, double xCoord, double yCoord, double zCoord, double m) {
        Coordinate coord = new Coordinate(xCoord, yCoord, zCoord);
        Point newPoint = gFactory.createPoint(coord);
        this.setGeometry((Geometry)newPoint);
        this.measure = new Double(m);
    }

    public GeometryPointAttribute(GeometryFactory gFactory, double xCoord, double yCoord, double zCoord) {
        Coordinate coord = new Coordinate(xCoord, yCoord, zCoord);
        Point newPoint = gFactory.createPoint(coord);
        this.setGeometry((Geometry)newPoint);
    }

    public GeometryPointAttribute(GeometryFactory gFactory, double xCoord, double yCoord) {
        Coordinate coord = new Coordinate(xCoord, yCoord);
        Point newPoint = gFactory.createPoint(coord);
        this.setGeometry((Geometry)newPoint);
    }

    public double x() {
        return ((Point)this.getGeometry()).getX();
    }

    public double y() {
        return ((Point)this.getGeometry()).getY();
    }

    public Double z() {
        Coordinate point = this.getGeometry().getCoordinate();
        return new Double(point.z);
    }

    public Double m() {
        return this.measure;
    }

    @Override
    public String geometryType() {
        return "http://www.opengis.net/gml#Point";
    }

    public static GeometryPointAttribute getInstance(GeometryFactory gFactory, double x, double y, double z) {
        return new GeometryPointAttribute(gFactory, x, y, z);
    }

    public static GeometryPointAttribute getInstance(GeometryFactory gFactory, double x, double y) {
        return new GeometryPointAttribute(gFactory, x, y);
    }

    public static GeometryPointAttribute getInstance(Node root, GeometryFactory gFactory) {
        GeometryPointAttribute newInstance = null;
        NodeList childes = root.getChildNodes();
        int i = 0;
        while (i < childes.getLength()) {
            Node child = childes.item(i);
            String name = child.getNodeName();
            if (name.contains("pos") || name.contains("coordinates")) {
                String value = child.getFirstChild().getNodeValue();
                String[] coord = name.contains("pos") ? value.split(" ") : value.split(",");
                if (coord.length == 2) {
                    newInstance = GeometryPointAttribute.getInstance(gFactory, Double.parseDouble(coord[0]), Double.parseDouble(coord[1]));
                } else if (coord.length == 3) {
                    newInstance = GeometryPointAttribute.getInstance(gFactory, Double.parseDouble(coord[0]), Double.parseDouble(coord[1]), Double.parseDouble(coord[2]));
                }
            }
            ++i;
        }
        return newInstance;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeometryPointAttribute)) {
            return false;
        }
        GeometryPointAttribute other = (GeometryPointAttribute)obj;
        return this.getGeometry().equals(other.getGeometry());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        String ret = "TYPE: \"";
        ret = String.valueOf(ret) + this.geometryType() + "\" ";
        ret = String.valueOf(ret) + "x:\"" + Double.toString(this.x()) + "\" ";
        ret = String.valueOf(ret) + "y:\"" + Double.toString(this.y()) + "\" ";
        ret = String.valueOf(ret) + "z:\"" + Double.toString(this.z()) + "\" ";
        if (this.m() != null) {
            ret = String.valueOf(ret) + "m:\"" + Double.toString(this.m()) + "\".";
        }
        return ret;
    }

    @Override
    public String encode() {
        String ret = "<gml:Point>";
        ret = String.valueOf(ret) + "<gml:pos>" + this.x() + " " + this.y();
        if (!this.z().isNaN()) {
            ret = String.valueOf(ret) + " " + this.z();
        }
        ret = String.valueOf(ret) + "</gml:pos>";
        ret = String.valueOf(ret) + "</gml:Point>";
        return ret;
    }
}

