/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ProcessingException;
import com.sun.xacml.attr.GeometryAttribute;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GeometryPolygonAttribute
extends GeometryAttribute {
    private final String type = "http://www.opengis.net/gml#Polygon";

    public GeometryPolygonAttribute(Geometry geom) {
        super(geom);
    }

    public GeometryPolygonAttribute(LinearRing ext, LinearRing[] ints, GeometryFactory gFactory) {
        Polygon newPolygon = gFactory.createPolygon(ext, ints);
        this.setGeometry((Geometry)newPolygon);
    }

    public double area() {
        return ((Polygon)this.getGeometry()).getArea();
    }

    public Point centroid() {
        return ((Polygon)this.getGeometry()).getCentroid();
    }

    public LineString exteriorRing() {
        return ((Polygon)this.getGeometry()).getExteriorRing();
    }

    public int numInteriorRing() {
        return ((Polygon)this.getGeometry()).getNumInteriorRing();
    }

    public LineString interiorRingN(int n) {
        return ((Polygon)this.getGeometry()).getInteriorRingN(n);
    }

    private static LinearRing processRing(Node root, GeometryFactory gFactory) {
        LinearRing newRing = null;
        NodeList childes = root.getChildNodes();
        int i = 0;
        while (i < childes.getLength()) {
            Node child = childes.item(i);
            String tag = child.getNodeName();
            if (tag.contains("posList")) {
                String dirtyValue = child.getFirstChild().getNodeValue();
                String value = dirtyValue.replace("\n", " ");
                value = value.trim();
                value = value.replaceAll("\\s\\s+", " ");
                Node dimAttr = child.getAttributes().getNamedItem("dimension");
                int dimension = Integer.parseInt(dimAttr.getNodeValue());
                String[] coords = value.split(" ");
                Coordinate[] points = new Coordinate[coords.length / dimension];
                int pointsIndex = 0;
                int j = 0;
                while (j < coords.length) {
                    if (dimension == 2) {
                        points[pointsIndex] = new Coordinate(Double.parseDouble(coords[j]), Double.parseDouble(coords[j + 1]));
                        ++pointsIndex;
                    } else if (dimension == 3) {
                        points[pointsIndex] = new Coordinate(Double.parseDouble(coords[j]), Double.parseDouble(coords[j + 1]), Double.parseDouble(coords[j + 2]));
                        ++pointsIndex;
                    }
                    j += dimension;
                }
                newRing = gFactory.createLinearRing(points);
            }
            ++i;
        }
        return newRing;
    }

    public static GeometryPolygonAttribute getInstance(LinearRing e, LinearRing[] i, GeometryFactory g) {
        return new GeometryPolygonAttribute(e, i, g);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GeometryPolygonAttribute getInstance(Node root, GeometryFactory gFactory) {
        GeometryPolygonAttribute newInstance = null;
        NodeList childes = root.getChildNodes();
        LinearRing exterior = null;
        ArrayList<LinearRing> interiors = new ArrayList<LinearRing>();
        int i = 0;
        while (i < childes.getLength()) {
            String tagEl;
            Node grandChild;
            int j;
            NodeList grandChildes;
            Node child = childes.item(i);
            String tag = child.getNodeName();
            if (tag.contains("exterior")) {
                if (exterior != null) throw new ProcessingException("More than 1 external ring definition found.");
                grandChildes = child.getChildNodes();
                j = 0;
                while (j < grandChildes.getLength()) {
                    grandChild = grandChildes.item(j);
                    tagEl = grandChild.getNodeName();
                    if (tagEl.contains("LinearRing")) {
                        exterior = GeometryPolygonAttribute.processRing(grandChild, gFactory);
                    }
                    ++j;
                }
            } else if (tag.contains("interior")) {
                grandChildes = child.getChildNodes();
                j = 0;
                while (j < grandChildes.getLength()) {
                    grandChild = grandChildes.item(j);
                    tagEl = grandChild.getNodeName();
                    if (tagEl.contains("LinearRing")) {
                        interiors.add(GeometryPolygonAttribute.processRing(grandChild, gFactory));
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (interiors.size() <= 0) return GeometryPolygonAttribute.getInstance(exterior, null, gFactory);
        return GeometryPolygonAttribute.getInstance(exterior, interiors.toArray(new LinearRing[interiors.size()]), gFactory);
    }

    @Override
    public String geometryType() {
        return "http://www.opengis.net/gml#Polygon";
    }

    @Override
    public String encode() {
        String ret = "<gml:Polygon>";
        ret = String.valueOf(ret) + "<gml:exterior>";
        ret = String.valueOf(ret) + "<gml:LinearRing>";
        Coordinate[] extCoords = ((Polygon)this.getGeometry()).getExteriorRing().getCoordinates();
        int dim = Double.isNaN(extCoords[0].z) ? 2 : 3;
        ret = String.valueOf(ret) + "<gml:posList dimension=\"" + dim + "\">";
        Coordinate[] coordinateArray = extCoords;
        int n = extCoords.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coord = coordinateArray[n2];
            ret = String.valueOf(ret) + " " + coord.x + " " + coord.y;
            if (dim == 3) {
                ret = String.valueOf(ret) + " " + coord.z;
            }
            ++n2;
        }
        ret = String.valueOf(ret) + "</gml:posList>";
        ret = String.valueOf(ret) + "</gml:LinearRing>";
        ret = String.valueOf(ret) + "</gml:exterior>";
        int numIntRings = ((Polygon)this.getGeometry()).getNumInteriorRing();
        if (numIntRings > 0) {
            ret = String.valueOf(ret) + "<gml:interior>";
            int i = 0;
            while (i < numIntRings) {
                ret = String.valueOf(ret) + "<gml:LinearRing>";
                Coordinate[] currIntCoords = ((Polygon)this.getGeometry()).getInteriorRingN(i).getCoordinates();
                ret = String.valueOf(ret) + "<gml:posList dimension=\"" + dim + "\">";
                Coordinate[] coordinateArray2 = currIntCoords;
                int n3 = currIntCoords.length;
                int n4 = 0;
                while (n4 < n3) {
                    Coordinate coord = coordinateArray2[n4];
                    ret = String.valueOf(ret) + " " + coord.x + " " + coord.y;
                    if (dim == 3) {
                        ret = String.valueOf(ret) + " " + coord.z;
                    }
                    ++n4;
                }
                ret = String.valueOf(ret) + "</gml:posList>";
                ret = String.valueOf(ret) + "</gml:LinearRing>";
                ++i;
            }
            ret = String.valueOf(ret) + "</gml:interior>";
        }
        ret = String.valueOf(ret) + "</gml:Polygon>";
        return ret;
    }
}

