/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.IPAddressAttribute;
import com.sun.xacml.attr.PortRange;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPv4AddressAttribute
extends IPAddressAttribute {
    public IPv4AddressAttribute(InetAddress address) {
        this(address, null, new PortRange());
    }

    public IPv4AddressAttribute(InetAddress address, InetAddress mask) {
        this(address, mask, new PortRange());
    }

    public IPv4AddressAttribute(InetAddress address, PortRange range) {
        this(address, null, range);
    }

    public IPv4AddressAttribute(InetAddress address, InetAddress mask, PortRange range) {
        super(address, mask, range);
    }

    protected static IPAddressAttribute getV4Instance(String value) throws UnknownHostException {
        int rangePos;
        InetAddress address = null;
        InetAddress mask = null;
        PortRange range = null;
        int maskPos = value.indexOf("/");
        if (maskPos == (rangePos = value.indexOf(":"))) {
            address = InetAddress.getByName(value);
        } else if (maskPos != -1) {
            address = InetAddress.getByName(value.substring(0, maskPos));
            if (rangePos != -1) {
                mask = InetAddress.getByName(value.substring(maskPos + 1, rangePos));
                range = PortRange.getInstance(value.substring(rangePos + 1, value.length()));
            } else {
                mask = InetAddress.getByName(value.substring(maskPos + 1, value.length()));
            }
        } else {
            address = InetAddress.getByName(value.substring(0, rangePos));
            range = PortRange.getInstance(value.substring(rangePos + 1, value.length()));
        }
        range = new PortRange();
        return new IPv4AddressAttribute(address, mask, range);
    }

    @Override
    public String encode() {
        String str = this.getAddress().getHostAddress();
        if (this.getMask() != null) {
            str = String.valueOf(str) + this.getMask().getHostAddress();
        }
        if (!this.getRange().isUnbound()) {
            str = String.valueOf(str) + ":" + this.getRange().encode();
        }
        return str;
    }
}

