/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import org.w3c.dom.Node;

public class IntegerAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#integer";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private long value;

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }

    public IntegerAttribute(long value) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = value;
    }

    public static IntegerAttribute getInstance(Node root) throws NumberFormatException {
        return IntegerAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static IntegerAttribute getInstance(String value) throws NumberFormatException {
        if (value.length() >= 1 && value.charAt(0) == '+') {
            value = value.substring(1);
        }
        return new IntegerAttribute(Long.parseLong(value));
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntegerAttribute)) {
            return false;
        }
        IntegerAttribute other = (IntegerAttribute)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public String encode() {
        return String.valueOf(this.value);
    }
}

