/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import org.w3c.dom.Node;

public class RFC822NameAttribute
extends AttributeValue {
    public static final String identifier = "urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private String value;

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }

    public RFC822NameAttribute(String value) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        String[] parts = value.split("@");
        if (parts.length != 2) {
            throw new IllegalArgumentException("invalid RFC822Name: " + value);
        }
        this.value = String.valueOf(parts[0]) + "@" + parts[1].toLowerCase();
    }

    public static RFC822NameAttribute getInstance(Node root) {
        return RFC822NameAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static RFC822NameAttribute getInstance(String value) {
        return new RFC822NameAttribute(value);
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RFC822NameAttribute)) {
            return false;
        }
        RFC822NameAttribute other = (RFC822NameAttribute)o;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String encode() {
        return this.value;
    }
}

