/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RoleAttribute
extends AttributeValue {
    public static final String identifier = "urn:my:dataType:role";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private URI name;
    private int expectedParams;
    private Map<String, URI> parameterTypes;
    private Map<String, AttributeValue> params;

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }

    protected RoleAttribute(URI name, int numParams) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.name = name;
        this.params = new HashMap<String, AttributeValue>();
        this.parameterTypes = new HashMap<String, URI>();
        this.expectedParams = numParams;
    }

    protected RoleAttribute(URI name, Map<String, AttributeValue> params, Map<String, URI> paramTypes) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.name = name;
        this.params = params;
        this.parameterTypes = paramTypes;
        this.expectedParams = paramTypes.size();
    }

    public static RoleAttribute getInstance(URI roleName, Map<String, AttributeValue> params, Map<String, URI> paramTypes, int numParams) {
        if (paramTypes.size() == 0) {
            return new RoleAttribute(roleName, numParams);
        }
        return new RoleAttribute(roleName, params, paramTypes);
    }

    private static ParametersData processParams(Node root) throws Exception {
        ParametersData paramsData = new ParametersData();
        NodeList childes = root.getChildNodes();
        int i = 0;
        while (i < childes.getLength()) {
            Node child = childes.item(i);
            String name = child.getNodeName();
            if (name.contentEquals("Param")) {
                NamedNodeMap attrs = child.getAttributes();
                Node dataTypeNode = attrs.getNamedItem("DataType");
                Node paramNameNode = attrs.getNamedItem("Name");
                URI dataType = new URI(dataTypeNode.getNodeValue());
                String paramName = paramNameNode.getNodeValue();
                if (child.getFirstChild() != null) {
                    String value = child.getFirstChild().getNodeValue();
                    AttributeFactory attrFactory = AttributeFactory.getInstance();
                    AttributeValue param = attrFactory.createValue(dataType, value);
                    paramsData.params.put(paramName, param);
                }
                paramsData.paramTypes.put(paramName, dataType);
            }
            ++i;
        }
        return paramsData;
    }

    public static RoleAttribute getInstance(Node root) throws Exception {
        ParametersData params = new ParametersData();
        int numParams = -1;
        URI roleNameURI = null;
        NodeList childes = root.getChildNodes();
        int i = 0;
        while (i < childes.getLength()) {
            Node child = childes.item(i);
            String name = child.getNodeName();
            if (name.contains("RoleName")) {
                if (child.getFirstChild() == null) {
                    throw new ParsingException("missing value for element RoleName");
                }
                String roleName = child.getFirstChild().getNodeValue();
                roleNameURI = new URI(roleName);
            }
            if (name.contains("RoleParams")) {
                Node numParamsNode = child.getAttributes().getNamedItem("Number");
                if (numParamsNode != null) {
                    numParams = Integer.parseInt(numParamsNode.getNodeValue());
                }
                params = RoleAttribute.processParams(child);
            }
            ++i;
        }
        if (numParams == -1 && params.paramTypes.size() == 0) {
            throw new ParsingException("Either number of parameters or explicit parameter list must be specified");
        }
        return RoleAttribute.getInstance(roleNameURI, params.params, params.paramTypes, numParams);
    }

    public int getNumParams() {
        return this.expectedParams;
    }

    public URI getName() {
        return this.name;
    }

    public Map<String, AttributeValue> getParams() {
        return this.params;
    }

    public Map<String, URI> getParamTypes() {
        return this.parameterTypes;
    }

    public boolean sameParamsType(RoleAttribute other) {
        if (this.parameterTypes.size() != other.parameterTypes.size()) {
            return false;
        }
        Set<String> paramNames = this.parameterTypes.keySet();
        Map<String, URI> otherParams = other.getParamTypes();
        for (String paramName : paramNames) {
            URI currParamType = this.parameterTypes.get(paramName);
            URI currOtherParamType = otherParams.get(paramName);
            if (currOtherParamType == null) {
                return false;
            }
            if (currParamType.compareTo(currOtherParamType) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean sameParams(RoleAttribute other) {
        if (this.params.size() != other.params.size()) {
            return false;
        }
        Set<String> paramNames = this.params.keySet();
        Map<String, AttributeValue> otherParams = other.getParams();
        for (String paramName : paramNames) {
            AttributeValue currParamAttr = this.params.get(paramName);
            AttributeValue currOtherParamAttr = otherParams.get(paramName);
            if (currOtherParamAttr == null) {
                return false;
            }
            if (currParamAttr.encode().contentEquals(currOtherParamAttr.encode())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String encode() {
        String str = "<RoleName>" + this.getName() + "</RoleName>";
        if (this.params.size() != 0) {
            str = String.valueOf(str) + "<RoleParams>";
            Set<String> paramNames = this.params.keySet();
            for (String paramName : paramNames) {
                AttributeValue currAttr = this.params.get(paramName);
                str = String.valueOf(str) + "<Param Name=\"" + paramName + "\" DataType=\"" + currAttr.getType().toString() + "\">";
                str = String.valueOf(str) + currAttr.encode();
                str = String.valueOf(str) + "</Param>";
            }
            str = String.valueOf(str) + "</RoleParams>";
        } else if (this.parameterTypes.size() != 0) {
            str = String.valueOf(str) + "<RoleParams>";
            Set<String> paramNames = this.parameterTypes.keySet();
            for (String paramName : paramNames) {
                URI currType = this.parameterTypes.get(paramName);
                str = String.valueOf(str) + "<Param Name=\"" + paramName + "\" DataType=\"" + currType.toString() + "\"/>";
            }
            str = String.valueOf(str) + "</RoleParams>";
        } else {
            str = String.valueOf(str) + "<RoleParams Number=\"" + this.expectedParams + "\" />";
        }
        return str;
    }

    private static class ParametersData {
        private HashMap<String, URI> paramTypes;
        private HashMap<String, AttributeValue> params = new HashMap();

        public ParametersData() {
            this.paramTypes = new HashMap();
        }
    }
}

