/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeProxy;
import com.sun.xacml.attr.BaseAttributeFactory;
import com.sun.xacml.attr.proxy.AnyURIAttributeProxy;
import com.sun.xacml.attr.proxy.Base64BinaryAttributeProxy;
import com.sun.xacml.attr.proxy.BooleanAttributeProxy;
import com.sun.xacml.attr.proxy.DNSNameAttributeProxy;
import com.sun.xacml.attr.proxy.DateAttributeProxy;
import com.sun.xacml.attr.proxy.DateTimeAttributeProxy;
import com.sun.xacml.attr.proxy.DayTimeDurationAttributeProxy;
import com.sun.xacml.attr.proxy.DoubleAttributeProxy;
import com.sun.xacml.attr.proxy.HexBinaryAttributeProxy;
import com.sun.xacml.attr.proxy.IPAddressAttributeProxy;
import com.sun.xacml.attr.proxy.IntegerAttributeProxy;
import com.sun.xacml.attr.proxy.RFC822NameAttributeProxy;
import com.sun.xacml.attr.proxy.StringAttributeProxy;
import com.sun.xacml.attr.proxy.TimeAttributeProxy;
import com.sun.xacml.attr.proxy.X500NameAttributeProxy;
import com.sun.xacml.attr.proxy.YearMonthDurationAttributeProxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;

public class StandardAttributeFactory
extends BaseAttributeFactory {
    private static StandardAttributeFactory factoryInstance = null;
    private static HashMap supportedDatatypes = null;
    private static Set supportedV1Identifiers;
    private static Set supportedV2Identifiers;
    private static final Logger logger;

    static {
        logger = Logger.getLogger(StandardAttributeFactory.class.getName());
    }

    private StandardAttributeFactory() {
        super(supportedDatatypes);
    }

    private static void initDatatypes() {
        logger.config("Initializing standard datatypes");
        supportedDatatypes = new HashMap();
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#boolean", new BooleanAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#string", new StringAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#date", new DateAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#time", new TimeAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#dateTime", new DateTimeAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/TR/2002/WD-xquery-operators-20020816#dayTimeDuration", new DayTimeDurationAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/TR/2002/WD-xquery-operators-20020816#yearMonthDuration", new YearMonthDurationAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#double", new DoubleAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#integer", new IntegerAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#anyURI", new AnyURIAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#hexBinary", new HexBinaryAttributeProxy());
        supportedDatatypes.put("http://www.w3.org/2001/XMLSchema#base64Binary", new Base64BinaryAttributeProxy());
        supportedDatatypes.put("urn:oasis:names:tc:xacml:1.0:data-type:x500Name", new X500NameAttributeProxy());
        supportedDatatypes.put("urn:oasis:names:tc:xacml:1.0:data-type:rfc822Name", new RFC822NameAttributeProxy());
        supportedV1Identifiers = Collections.unmodifiableSet(supportedDatatypes.keySet());
        supportedDatatypes.put("urn:oasis:names:tc:xacml:2.0:data-type:dnsName", new DNSNameAttributeProxy());
        supportedDatatypes.put("urn:oasis:names:tc:xacml:2.0:data-type:ipAddress", new IPAddressAttributeProxy());
        supportedV2Identifiers = Collections.unmodifiableSet(supportedDatatypes.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandardAttributeFactory getFactory() {
        if (factoryInstance != null) return factoryInstance;
        Class<StandardAttributeFactory> clazz = StandardAttributeFactory.class;
        synchronized (StandardAttributeFactory.class) {
            if (factoryInstance != null) return factoryInstance;
            StandardAttributeFactory.initDatatypes();
            factoryInstance = new StandardAttributeFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factoryInstance;
        }
    }

    public static AttributeFactory getNewFactory() {
        StandardAttributeFactory.getFactory();
        return new BaseAttributeFactory(supportedDatatypes);
    }

    public static Set getStandardDatatypes(String xacmlVersion) throws UnknownIdentifierException {
        if (xacmlVersion.equals("urn:oasis:names:tc:xacml:1.0:policy")) {
            return supportedV1Identifiers;
        }
        if (xacmlVersion.equals("urn:oasis:names:tc:xacml:2.0:policy:schema:os")) {
            return supportedV2Identifiers;
        }
        throw new UnknownIdentifierException("Unknown XACML version: " + xacmlVersion);
    }

    @Override
    public void addDatatype(String id, AttributeProxy proxy) {
        throw new UnsupportedOperationException("a standard factory cannot support new datatypes");
    }
}

