/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.TreeSet;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimeExpressionAttribute
extends AttributeValue {
    public static final String identifier = "urn:my:periodic-expression";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private Date intervalStart;
    private Date intervalEnd;
    private TreeSet<Integer>[] calendars = null;
    private int howManyDcalendars;
    private int dCalendarId;
    private static TimeZone tz;
    private static final DateFormat DEFAULT_DATEFORMAT;
    public static final int ID_HOURS_CAL = 4;
    public static final int ID_DAYS_CAL = 3;
    public static final int ID_WEEKS_CAL = 2;
    public static final int ID_MONTHS_CAL = 1;
    public static final int ID_YEARS_CAL = 0;

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
        DEFAULT_DATEFORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        tz = TimeZone.getDefault();
        DEFAULT_DATEFORMAT.setTimeZone(tz);
    }

    protected TimeExpressionAttribute() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    protected TimeExpressionAttribute(TimeZone tz) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        TimeExpressionAttribute.tz = tz;
    }

    private static void verifyCalendarType(String type) throws ParsingException {
        if (TimeExpressionAttribute.getCalendarTypeIndex(type) < 0) {
            throw new ParsingException("Invalid calendar type found: " + type);
        }
    }

    private static void checkOi(int value) throws ParsingException {
        if (value < 0) {
            throw new ParsingException("Calendar's values must be positive, found value: " + value);
        }
    }

    private static TreeSet<Integer> processCalendar(String type, String value) throws ParsingException {
        String[] intervals;
        int calIndex = TimeExpressionAttribute.getCalendarTypeIndex(type);
        value = value.replace("\n", " ");
        value = value.trim();
        value = value.replaceAll("\\s\\s+", " ");
        TreeSet<Integer> t = new TreeSet<Integer>();
        String[] stringArray = intervals = value.split(",");
        int n = intervals.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String[] intervalBounds = element.split("-");
            if (intervalBounds.length > 2) {
                throw new ParsingException("Invalid interval definition for: " + element);
            }
            if (intervalBounds.length == 2) {
                int lBound = 1;
                int hBound = 0;
                try {
                    lBound = Integer.parseInt(intervalBounds[0].trim());
                    hBound = Integer.parseInt(intervalBounds[1].trim());
                }
                catch (NumberFormatException e) {
                    throw new ParsingException(e.getMessage());
                }
                TimeExpressionAttribute.checkOi(lBound);
                TimeExpressionAttribute.checkOi(hBound);
                if (lBound > hBound) {
                    throw new ParsingException("Invalid interval: [" + lBound + "," + hBound + "]");
                }
                int i = lBound;
                while (i <= hBound) {
                    t.add(i);
                    ++i;
                }
            } else {
                int n3 = -1;
                try {
                    n3 = Integer.parseInt(intervalBounds[0].trim());
                }
                catch (NumberFormatException e) {
                    throw new ParsingException(e.getMessage());
                }
                TimeExpressionAttribute.checkOi(n3);
                t.add(n3);
            }
            ++n2;
        }
        return t;
    }

    public static int getCalendarTypeIndex(String type) {
        if (type.contains("Years")) {
            return 0;
        }
        if (type.contains("Months")) {
            return 1;
        }
        if (type.contains("Weeks")) {
            return 2;
        }
        if (type.contains("Days")) {
            return 3;
        }
        if (type.contains("Hours")) {
            return 4;
        }
        return -1;
    }

    public static String getCalendarType(int id) {
        switch (id) {
            case 0: {
                return "Years";
            }
            case 1: {
                return "Months";
            }
            case 2: {
                return "Weeks";
            }
            case 3: {
                return "Days";
            }
            case 4: {
                return "Hours";
            }
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TimeExpressionAttribute getInstance(Node root, TimeZone tZone) throws ParsingException {
        Date intervalS = null;
        Date intervalE = null;
        int calendarLengthR = -1;
        int calendarLengthIndex = -1;
        boolean[] typeMap = new boolean[5];
        TreeSet[] cals = new TreeSet[5];
        NodeList childes = root.getChildNodes();
        int i = 0;
        while (i < childes.getLength()) {
            NodeList grandChildes;
            Node child = childes.item(i);
            String name = child.getNodeName();
            if (name.contains("Interval")) {
                DateFormat df;
                grandChildes = child.getChildNodes();
                NamedNodeMap attrs = child.getAttributes();
                Node dFormatNode = attrs.getNamedItem("DateFormat");
                if (dFormatNode != null) {
                    df = new SimpleDateFormat(dFormatNode.getNodeValue());
                    if (tZone != null) {
                        df.setTimeZone(tZone);
                    } else {
                        df.setTimeZone(tz);
                    }
                } else {
                    df = DEFAULT_DATEFORMAT;
                }
                int j = 0;
                while (j < grandChildes.getLength()) {
                    Node grandChild = grandChildes.item(j);
                    String childName = grandChild.getNodeName();
                    if (childName.contains("Start") || childName.contains("End")) {
                        Date d;
                        try {
                            d = df.parse(grandChild.getFirstChild().getNodeValue());
                        }
                        catch (Exception e) {
                            throw new ParsingException("Invalid data format for element: " + grandChild.getFirstChild().getNodeValue() + ". It should be:" + df.toString(), e);
                        }
                        if (childName.contains("Start")) {
                            intervalS = d;
                        } else {
                            intervalE = d;
                        }
                    }
                    ++j;
                }
            }
            if (name.contains("PeriodicExp")) {
                grandChildes = child.getChildNodes();
                int j = 0;
                while (j < grandChildes.getLength()) {
                    Node grandChild = grandChildes.item(j);
                    String childName = grandChild.getNodeName();
                    if (childName.contains("CalendarStart") || childName.contains("CalendarLength")) {
                        NamedNodeMap attrs = grandChild.getAttributes();
                        Node calendarTypeNode = attrs.getNamedItem("Type");
                        if (calendarTypeNode == null) {
                            throw new ParsingException("Missing 'Type' attribute for Calendar element");
                        }
                        String calendarType = calendarTypeNode.getNodeValue();
                        TimeExpressionAttribute.verifyCalendarType(calendarType);
                        int calIndex = TimeExpressionAttribute.getCalendarTypeIndex(calendarType);
                        if (childName.contains("CalendarStart")) {
                            TreeSet<Integer> tree;
                            if (typeMap[calIndex]) throw new ParsingException("Calendar of type " + calendarType + " declared more than once");
                            String calendarValue = grandChild.getFirstChild().getNodeValue();
                            cals[calIndex] = tree = TimeExpressionAttribute.processCalendar(calendarType, calendarValue);
                            typeMap[calIndex] = true;
                        } else {
                            if (calendarLengthR >= 0) throw new ParsingException("More than one CalendarLength element found");
                            try {
                                calendarLengthR = Integer.parseInt(grandChild.getFirstChild().getNodeValue().trim());
                            }
                            catch (Exception e) {
                                throw new ParsingException(e.getMessage());
                            }
                            TimeExpressionAttribute.checkOi(calendarLengthR);
                            calendarLengthIndex = calIndex;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        int j = -1;
        int i2 = 0;
        while (i2 < typeMap.length) {
            if (typeMap[i2]) {
                j = i2;
            }
            ++i2;
        }
        if (j == -1 && calendarLengthR >= 0) {
            throw new ParsingException("Missing CalendarLength element");
        }
        if (j > -1 && calendarLengthR < 0) {
            throw new ParsingException("No CalendarLength element found");
        }
        if (j <= calendarLengthIndex) return TimeExpressionAttribute.getInstance(intervalS, intervalE, cals, calendarLengthIndex, calendarLengthR, tz);
        throw new ParsingException("Calendar used to express length can't be bigger of any calendar used in starting points definition. Smallest calendar in definition: " + TimeExpressionAttribute.getCalendarType(j) + ",calendar length: " + TimeExpressionAttribute.getCalendarType(calendarLengthIndex));
    }

    public static TimeExpressionAttribute getInstance(Date intervalStart, Date intervalEnd, TreeSet<Integer>[] calendarStart, int calLengthIndex, int calLengthR, TimeZone tz) {
        TimeExpressionAttribute pExp = new TimeExpressionAttribute(tz);
        pExp.intervalStart = intervalStart;
        pExp.intervalEnd = intervalEnd;
        pExp.calendars = calendarStart;
        pExp.howManyDcalendars = calLengthR;
        pExp.dCalendarId = calLengthIndex;
        return pExp;
    }

    public TimeZone getTimeZone() {
        return tz;
    }

    public TreeSet<Integer>[] getStartDefinition() {
        return this.calendars;
    }

    public Date getIntervalStart() {
        return this.intervalStart;
    }

    public Date getIntervalEnd() {
        return this.intervalEnd;
    }

    public int getCalendarLengthIndex() {
        return this.dCalendarId;
    }

    public int getCalendarLengthValue() {
        return this.howManyDcalendars;
    }

    @Override
    public String encode() {
        return null;
    }
}

