/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import java.math.BigInteger;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Node;

public class YearMonthDurationAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#yearMonthDuration";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private static final String patternString = "(\\-)?P((\\d+)?Y)?((\\d+)?M)?";
    private static final int GROUP_SIGN = 1;
    private static final int GROUP_YEARS = 3;
    private static final int GROUP_MONTHS = 5;
    private static BigInteger big12;
    private static BigInteger bigMaxLong;
    private static Pattern pattern;
    private boolean negative;
    private long years;
    private long months;
    private long totalMonths;
    private String encodedValue = null;

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }

    public YearMonthDurationAttribute(boolean negative, long years, long months) throws IllegalArgumentException {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.negative = negative;
        this.years = years;
        this.months = months;
        if (years > Integer.MAX_VALUE || months > Integer.MAX_VALUE) {
            if (big12 == null) {
                big12 = BigInteger.valueOf(12L);
                bigMaxLong = BigInteger.valueOf(Long.MAX_VALUE);
            }
            BigInteger bigMonths = BigInteger.valueOf(months);
            BigInteger bigYears = BigInteger.valueOf(years);
            BigInteger bigTotal = bigYears.multiply(big12).add(bigMonths);
            if (bigTotal.compareTo(bigMaxLong) == 1) {
                throw new IllegalArgumentException("total number of months exceeds Long.MAX_VALUE");
            }
            this.totalMonths = bigTotal.longValue();
            if (negative) {
                this.totalMonths = -this.totalMonths;
            }
        } else {
            this.totalMonths = (years * 12L + months) * (long)(negative ? -1 : 1);
        }
    }

    public static YearMonthDurationAttribute getInstance(Node root) throws ParsingException {
        return YearMonthDurationAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    private static long parseGroup(Matcher matcher, int groupNumber) throws NumberFormatException {
        long groupLong = 0L;
        if (matcher.start(groupNumber) != -1) {
            String groupString = matcher.group(groupNumber);
            groupLong = Long.parseLong(groupString);
        }
        return groupLong;
    }

    public static YearMonthDurationAttribute getInstance(String value) throws ParsingException {
        Matcher matcher;
        boolean matches;
        boolean negative = false;
        long years = 0L;
        long months = 0L;
        if (pattern == null) {
            try {
                pattern = Pattern.compile(patternString);
            }
            catch (PatternSyntaxException e) {
                throw new ParsingException("unexpected pattern syntax error");
            }
        }
        if (!(matches = (matcher = pattern.matcher(value)).matches())) {
            throw new ParsingException("Syntax error in yearMonthDuration");
        }
        if (matcher.start(1) != -1) {
            negative = true;
        }
        try {
            years = YearMonthDurationAttribute.parseGroup(matcher, 3);
            months = YearMonthDurationAttribute.parseGroup(matcher, 5);
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Unable to handle number size");
        }
        return new YearMonthDurationAttribute(negative, years, months);
    }

    public boolean isNegative() {
        return this.negative;
    }

    public long getYears() {
        return this.years;
    }

    public long getMonths() {
        return this.months;
    }

    public boolean equals(Object o) {
        if (!(o instanceof YearMonthDurationAttribute)) {
            return false;
        }
        YearMonthDurationAttribute other = (YearMonthDurationAttribute)o;
        return this.totalMonths == other.totalMonths;
    }

    public int hashCode() {
        return (int)this.totalMonths ^ (int)(this.totalMonths >> 32);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("YearMonthDurationAttribute: [\n");
        sb.append("  Negative: " + this.negative);
        sb.append("  Years: " + this.years);
        sb.append("  Months: " + this.months);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String encode() {
        if (this.encodedValue != null) {
            return this.encodedValue;
        }
        StringBuffer buf = new StringBuffer(10);
        if (this.negative) {
            buf.append('-');
        }
        buf.append('P');
        if (this.years != 0L || this.months == 0L) {
            buf.append(Long.toString(this.years));
            buf.append('Y');
        }
        if (this.months != 0L) {
            buf.append(Long.toString(this.months));
            buf.append('M');
        }
        this.encodedValue = buf.toString();
        return this.encodedValue;
    }
}

