/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.combine;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeValue;
import java.io.OutputStream;
import java.io.PrintStream;
import org.w3c.dom.Node;

public class CombinerParameter {
    private String name;
    private AttributeValue value;

    public CombinerParameter(String name, AttributeValue value) {
        this.name = name;
        this.value = value;
    }

    public static CombinerParameter getInstance(Node root) throws ParsingException {
        String name = root.getAttributes().getNamedItem("ParameterName").getNodeValue();
        AttributeFactory attrFactory = AttributeFactory.getInstance();
        AttributeValue value = null;
        try {
            value = attrFactory.createValue(root.getFirstChild());
        }
        catch (UnknownIdentifierException uie) {
            throw new ParsingException("Unknown AttributeId", uie);
        }
        return new CombinerParameter(name, value);
    }

    public String getName() {
        return this.name;
    }

    public AttributeValue getValue() {
        return this.value;
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(String.valueOf(indent) + "<CombinerParameter ParameterName=\"" + this.getName() + "\">");
        indenter.in();
        this.getValue().encode(output, indenter);
        out.println(String.valueOf(indent) + "</CombinerParameter>");
        indenter.out();
    }
}

