/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.combine;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Rule;
import com.sun.xacml.combine.RuleCombinerElement;
import com.sun.xacml.combine.RuleCombiningAlgorithm;
import com.sun.xacml.ctx.Result;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;

public class DenyOverridesRuleAlg
extends RuleCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:deny-overrides";
    private static URI identifierURI;
    private static RuntimeException earlyException;

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }

    public DenyOverridesRuleAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    protected DenyOverridesRuleAlg(URI identifier) {
        super(identifier);
    }

    @Override
    public Result combine(EvaluationCtx context, List parameters, List ruleElements) {
        boolean atLeastOneError = false;
        boolean potentialDeny = false;
        boolean atLeastOnePermit = false;
        Result firstIndeterminateResult = null;
        Iterator it = ruleElements.iterator();
        while (it.hasNext()) {
            Rule rule = ((RuleCombinerElement)it.next()).getRule();
            Result result = rule.evaluate(context);
            int value = result.getDecision();
            if (value == 1) {
                return result;
            }
            if (value == 2) {
                atLeastOneError = true;
                if (firstIndeterminateResult == null) {
                    firstIndeterminateResult = result;
                }
                if (rule.getEffect() != 1) continue;
                potentialDeny = true;
                continue;
            }
            if (value != 0) continue;
            atLeastOnePermit = true;
        }
        if (potentialDeny) {
            return firstIndeterminateResult;
        }
        if (atLeastOnePermit) {
            return new Result(0, context.getResourceId().encode());
        }
        if (atLeastOneError) {
            return firstIndeterminateResult;
        }
        return new Result(3, context.getResourceId().encode());
    }
}

