/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.combine;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.EvaluationDataBuffer;
import com.sun.xacml.EvaluationDataBuffers;
import com.sun.xacml.Rule;
import com.sun.xacml.attr.TimeAttribute;
import com.sun.xacml.combine.RuleCombinerElement;
import com.sun.xacml.combine.RuleCombiningAlgorithm;
import com.sun.xacml.ctx.EnablingResult;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.event.Event;
import com.sun.xacml.location.LocationHandler;
import com.sun.xacml.location.LocationLogical;
import com.sun.xacml.location.LocationType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MyRuleCombiningAlgorithm
extends RuleCombiningAlgorithm {
    private LocationHandler locationHandler = LocationHandler.getInstance(null);
    public static final String algId = "my:rule-combining-algorithm:deny-overrides";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private HashMap<Rule, Event> satEvents = new HashMap();
    private HashMap<Rule, Object> satLocations = new HashMap();

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }

    public MyRuleCombiningAlgorithm() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    private void storeSatisfyingElements(Rule r, EvaluationDataBuffer buff) {
        this.satLocations.put(r, buff.getStoredLocation());
        this.satEvents.put(r, buff.getStoredEvent());
        buff.storeEvent(null);
        buff.storeLocation(null);
    }

    private void clearSatData() {
        if (!this.satEvents.isEmpty()) {
            this.satEvents.clear();
        }
        if (!this.satEvents.isEmpty()) {
            this.satLocations.clear();
        }
    }

    private int compareRulesWithoutSpace(Rule r1, Rule r2) {
        if (r1.getPriority() > r2.getPriority()) {
            return 1;
        }
        if (r1.getPriority() == r2.getPriority()) {
            int ev2Prios;
            Event ev1 = this.satEvents.get(r1);
            Event ev2 = this.satEvents.get(r2);
            if (ev1 == null && ev2 == null) {
                return 0;
            }
            if (ev1 == null) {
                return -1;
            }
            if (ev2 == null) {
                return 1;
            }
            int ev1Prios = ev1.getPriority();
            if (ev1Prios > (ev2Prios = ev2.getPriority())) {
                return 1;
            }
            if (ev1Prios == ev2Prios) {
                return 0;
            }
        }
        return -1;
    }

    private int compareRulesOnlySpace(Rule r1, Rule r2) {
        Object r1Loc = this.satLocations.get(r1);
        Object r2Loc = this.satLocations.get(r2);
        if (r1Loc == null) {
            r1Loc = this.locationHandler.getLogicalUniverseInstance();
        }
        if (r2Loc == null) {
            r2Loc = this.locationHandler.getLogicalUniverseInstance();
        }
        return this.locationHandler.findRelationBetween(r1Loc, r2Loc);
    }

    private Map<String, List<Event>> retrieveSatEvents(LinkedList<Rule> permits) {
        HashMap<String, List<Event>> events = new HashMap<String, List<Event>>();
        for (Rule currRule : permits) {
            Event currEv = this.satEvents.get(currRule);
            if (currEv == null) continue;
            String evName = currEv.getEventName();
            if (!events.containsKey(evName)) {
                events.put(evName, new LinkedList());
            }
            ((List)events.get(evName)).add(currEv);
        }
        return events;
    }

    private Map<String, List<Object>> retrieveSatLocations(LinkedList<Rule> permits) {
        HashMap<String, List<Object>> locations = new HashMap<String, List<Object>>();
        for (Rule currRule : permits) {
            Object currLoc = this.satLocations.get(currRule);
            if (currLoc == null) continue;
            String locName = null;
            if (currLoc instanceof LocationType) {
                locName = ((LocationType)currLoc).getName();
            } else if (currLoc instanceof LocationLogical) {
                locName = ((LocationLogical)currLoc).getName();
            }
            if (!locations.containsKey(locName)) {
                locations.put(locName, new LinkedList());
            }
            ((List)locations.get(locName)).add(currLoc);
        }
        return locations;
    }

    @Override
    public Result combine(EvaluationCtx context, List parameters, List ruleElements) {
        this.clearSatData();
        TimeAttribute timestamp = context.getCurrentTime();
        EvaluationDataBuffer evBuffer = EvaluationDataBuffers.requestBuffer(timestamp);
        LinkedList<Rule> mostSpecificDenies = new LinkedList<Rule>();
        LinkedList<Rule> mostSpecificPermits = new LinkedList<Rule>();
        Iterator it = ruleElements.iterator();
        while (it.hasNext()) {
            int comparison;
            Rule rule = ((RuleCombinerElement)it.next()).getRule();
            Result result = rule.evaluate(context);
            int value = result.getDecision();
            if (value <= 1) {
                this.storeSatisfyingElements(rule, evBuffer);
            }
            if (value == 1) {
                if (mostSpecificDenies.size() == 0) {
                    mostSpecificDenies.add(rule);
                } else {
                    comparison = this.compareRulesWithoutSpace(rule, (Rule)mostSpecificDenies.getFirst());
                    switch (comparison) {
                        case 1: {
                            mostSpecificDenies.clear();
                        }
                        case 0: {
                            mostSpecificDenies.add(rule);
                        }
                    }
                }
            }
            if (value != 0) continue;
            if (mostSpecificPermits.size() == 0) {
                mostSpecificPermits.add(rule);
                continue;
            }
            comparison = this.compareRulesWithoutSpace(rule, mostSpecificPermits.getFirst());
            switch (comparison) {
                case 1: {
                    mostSpecificPermits.clear();
                }
                case 0: {
                    mostSpecificPermits.add(rule);
                }
            }
        }
        if (mostSpecificDenies.size() != 0 && mostSpecificPermits.size() != 0) {
            int comparison = this.compareRulesWithoutSpace((Rule)mostSpecificPermits.getFirst(), (Rule)mostSpecificDenies.getFirst());
            switch (comparison) {
                case 1: {
                    EvaluationDataBuffers.releaseBuffer(timestamp);
                    return new EnablingResult(0, context.getResourceId().encode(), this.retrieveSatEvents(mostSpecificPermits), this.retrieveSatLocations(mostSpecificPermits));
                }
                case -1: {
                    EvaluationDataBuffers.releaseBuffer(timestamp);
                    return new EnablingResult(1, context.getResourceId().encode(), null, null);
                }
                case 0: {
                    LinkedList<Rule> validPermits = new LinkedList<Rule>();
                    int i = 0;
                    while (i < mostSpecificPermits.size()) {
                        Rule currPermit = mostSpecificPermits.get(i);
                        int j = 0;
                        while (j < mostSpecificDenies.size()) {
                            Rule currDeny = (Rule)mostSpecificDenies.get(j);
                            if (this.compareRulesOnlySpace(currPermit, currDeny) != -1) break;
                            ++j;
                        }
                        if (j == mostSpecificDenies.size()) {
                            validPermits.add(currPermit);
                        }
                        ++i;
                    }
                    if (validPermits.size() > 0) {
                        EvaluationDataBuffers.releaseBuffer(timestamp);
                        return new EnablingResult(0, context.getResourceId().encode(), this.retrieveSatEvents(validPermits), this.retrieveSatLocations(validPermits));
                    }
                    EvaluationDataBuffers.releaseBuffer(timestamp);
                    return new EnablingResult(1, context.getResourceId().encode(), null, null);
                }
            }
        }
        if (mostSpecificPermits.size() != 0) {
            EvaluationDataBuffers.releaseBuffer(timestamp);
            return new EnablingResult(0, context.getResourceId().encode(), this.retrieveSatEvents(mostSpecificPermits), this.retrieveSatLocations(mostSpecificPermits));
        }
        EvaluationDataBuffers.releaseBuffer(timestamp);
        return new EnablingResult(1, context.getResourceId().encode(), null, null);
    }
}

