/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.combine;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.MatchResult;
import com.sun.xacml.combine.PolicyCombinerElement;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Status;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OnlyOneApplicablePolicyAlg
extends PolicyCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:only-one-applicable";
    private static URI identifierURI;
    private static RuntimeException earlyException;

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }

    public OnlyOneApplicablePolicyAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    @Override
    public Result combine(EvaluationCtx context, List parameters, List policyElements) {
        boolean atLeastOne = false;
        AbstractPolicy selectedPolicy = null;
        Iterator it = policyElements.iterator();
        while (it.hasNext()) {
            AbstractPolicy policy = ((PolicyCombinerElement)it.next()).getPolicy();
            MatchResult match = policy.match(context);
            int result = match.getResult();
            if (result == 2) {
                return new Result(2, match.getStatus(), context.getResourceId().encode());
            }
            if (result != 0) continue;
            if (atLeastOne) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                String message = "Too many applicable policies";
                return new Result(2, new Status(code, message), context.getResourceId().encode());
            }
            atLeastOne = true;
            selectedPolicy = policy;
        }
        if (atLeastOne) {
            return selectedPolicy.evaluate(context);
        }
        return new Result(3, context.getResourceId().encode());
    }
}

