/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.PolicyMetaData;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.Expression;
import com.sun.xacml.cond.ExpressionHandler;
import com.sun.xacml.cond.Function;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.VariableManager;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Apply
implements Evaluatable {
    private Function function;
    private List xprs;

    public Apply(Function function, List xprs) throws IllegalArgumentException {
        function.checkInputs(xprs);
        this.function = function;
        this.xprs = Collections.unmodifiableList(new ArrayList(xprs));
    }

    public Apply(Function function, List xprs, boolean isCondition) throws IllegalArgumentException {
        if (isCondition) {
            throw new IllegalArgumentException("As of version 2.0 an Apply may not represent a Condition");
        }
        function.checkInputs(xprs);
        this.function = function;
        this.xprs = Collections.unmodifiableList(new ArrayList(xprs));
    }

    public static Apply getConditionInstance(Node root, String xpathVersion, VariableManager manager) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getConditionInstance(), new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), manager);
    }

    public static Apply getConditionInstance(Node root, String xpathVersion) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getConditionInstance(), new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), null);
    }

    public static Apply getInstance(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getGeneralInstance(), metaData, manager);
    }

    public static Apply getInstance(Node root, String xpathVersion) throws ParsingException {
        return Apply.getInstance(root, FunctionFactory.getGeneralInstance(), new PolicyMetaData("urn:oasis:names:tc:xacml:1.0:policy", xpathVersion), null);
    }

    private static Apply getInstance(Node root, FunctionFactory factory, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        Function function = ExpressionHandler.getFunction(root, metaData, factory);
        ArrayList<Expression> xprs = new ArrayList<Expression>();
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Expression xpr = ExpressionHandler.parseExpression(nodes.item(i), metaData, manager);
            if (xpr != null) {
                xprs.add(xpr);
            }
            ++i;
        }
        return new Apply(function, xprs);
    }

    public Function getFunction() {
        return this.function;
    }

    @Override
    public List getChildren() {
        return this.xprs;
    }

    public boolean isCondition() {
        return false;
    }

    @Override
    public EvaluationResult evaluate(EvaluationCtx context) {
        return this.function.evaluate(this.xprs, context);
    }

    @Override
    public URI getType() {
        return this.function.getReturnType();
    }

    @Override
    public boolean returnsBag() {
        return this.function.returnsBag();
    }

    @Override
    public boolean evaluatesToBag() {
        return this.function.returnsBag();
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(String.valueOf(indent) + "<Apply FunctionId=\"" + this.function.getIdentifier() + "\">");
        indenter.in();
        for (Expression xpr : this.xprs) {
            xpr.encode(output, indenter);
        }
        indenter.out();
        out.println(String.valueOf(indent) + "</Apply>");
    }
}

