/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.GeometryPointAttribute;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import com.sun.xacml.event.Event;
import com.sun.xacml.event.EventHandler;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EventGeneratedByFunction
extends FunctionBase {
    private EventHandler eventHandler = EventHandler.getInstance();
    public static final String FUNCTION_NS = "urn:my:function:event:";
    public static final String NAME_GENERATED_BY = "urn:my:function:event:generated-by-and-visible-at";
    private static final int ID_GENERATED_BY = 0;
    private static final String[] params = new String[]{"http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#string", "urn:ogc:def:dataType:geoxacml:1.0:geometry", "http://www.w3.org/2001/XMLSchema#string"};
    private static final boolean[] bagParams = new boolean[4];

    public EventGeneratedByFunction(String functionName) {
        super(functionName, EventGeneratedByFunction.getId(functionName), params, bagParams, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_GENERATED_BY);
        return set;
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_GENERATED_BY)) {
            return 0;
        }
        throw new IllegalArgumentException("unknown event function " + functionName);
    }

    @Override
    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        StringAttribute generatingUser = (StringAttribute)argValues[0];
        StringAttribute eventName = (StringAttribute)argValues[1];
        GeometryPointAttribute pointAttr = (GeometryPointAttribute)argValues[2];
        StringAttribute userName = (StringAttribute)argValues[3];
        Coordinate point = ((Point)pointAttr.getGeometry()).getCoordinate();
        Event ev = this.eventHandler.isEventGeneratedByVisibleAt(point, eventName.getValue(), userName.getValue(), generatingUser.getValue());
        boolean visible = ev != null;
        return EvaluationResult.getInstance(visible);
    }
}

