/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.MyBasicEvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.GeometryAttribute;
import com.sun.xacml.attr.GeometryPointAttribute;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import com.sun.xacml.ctx.Subject;
import com.sun.xacml.event.Event;
import com.sun.xacml.event.EventHandler;
import com.sun.xacml.location.LocationHandler;
import com.sun.xacml.location.LocationLogical;
import com.vividsolutions.jts.geom.Coordinate;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EventLocationFunction
extends FunctionBase {
    private LocationHandler locationHandler = LocationHandler.getInstance(null);
    private EventHandler eventHandler = EventHandler.getInstance();
    public static final String FUNCTION_NS = "urn:my:function:event:";
    public static final String NAME_VISIBLE_IN = "urn:my:function:event:visible-in";
    public static final String NAME_NOTVISIBLE_IN = "urn:my:function:event:not-visible-in";
    private static final int ID_VISIBLE_IN = 0;
    private static final int ID_NOTVISIBLE_IN = 1;

    public EventLocationFunction(String functionName) {
        super(functionName, EventLocationFunction.getId(functionName), "http://www.w3.org/2001/XMLSchema#string", false, 3, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_VISIBLE_IN)) {
            return 0;
        }
        if (functionName.equals(NAME_NOTVISIBLE_IN)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown spatial function " + functionName);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_VISIBLE_IN);
        set.add(NAME_NOTVISIBLE_IN);
        return set;
    }

    @Override
    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        StringAttribute eventName = (StringAttribute)argValues[0];
        StringAttribute logicalLocName = (StringAttribute)argValues[1];
        StringAttribute userName = (StringAttribute)argValues[2];
        List<LocationLogical> llocs = null;
        if (context instanceof MyBasicEvaluationCtx) {
            llocs = ((MyBasicEvaluationCtx)context).getLogicalLocationsNamed(logicalLocName.getValue());
        } else {
            EvaluationResult positionRes;
            try {
                positionRes = context.getSubjectAttribute(new URI("urn:ogc:def:dataType:geoxacml:1.0:geometry"), new URI("urn:my:subject:position-coord"), Subject.DEFAULT_CATEGORY);
            }
            catch (URISyntaxException e) {
                return EvaluationResult.getFalseInstance();
            }
            BagAttribute valueBag = (BagAttribute)positionRes.getAttributeValue();
            Iterator valueBagIt = valueBag.iterator();
            GeometryAttribute positionAttr = null;
            while (valueBagIt.hasNext()) {
                Object currEl = valueBagIt.next();
                if (!(currEl instanceof GeometryPointAttribute)) continue;
                positionAttr = (GeometryPointAttribute)currEl;
                break;
            }
            if (positionAttr == null) {
                return EvaluationResult.getFalseInstance();
            }
            Coordinate positionCoord = positionAttr.getGeometry().getCoordinate();
            llocs = this.locationHandler.getLocationsContaining(positionCoord);
        }
        LocationLogical wantedLL = null;
        for (LocationLogical ll : llocs) {
            if (!ll.getName().equals(logicalLocName.getValue())) continue;
            wantedLL = ll;
            break;
        }
        if (wantedLL == null) {
            return EvaluationResult.getFalseInstance();
        }
        Event visibleEv = this.eventHandler.isEventVisibleIn(wantedLL, eventName.getValue(), userName.getValue());
        boolean visible = visibleEv != null;
        int funcId = this.getFunctionId();
        if (funcId == 0) {
            return EvaluationResult.getInstance(visible);
        }
        return EvaluationResult.getInstance(!visible);
    }
}

