/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.EvaluationDataBuffers;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.GeometryPointAttribute;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.attr.TimeAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import com.sun.xacml.event.Event;
import com.sun.xacml.event.EventHandler;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EventPointFunction
extends FunctionBase {
    private EventHandler eventHandler = EventHandler.getInstance();
    public static final String FUNCTION_NS = "urn:my:function:event:";
    public static final String NAME_VISIBLE_AT = "urn:my:function:event:visible-at";
    public static final String NAME_NOTVISIBLE_AT = "urn:my:function:event:not-visible-at";
    private static final int ID_VISIBLE_AT = 0;
    private static final int ID_NOTVISIBLE_AT = 1;
    private static final String[] params = new String[]{"http://www.w3.org/2001/XMLSchema#string", "urn:ogc:def:dataType:geoxacml:1.0:geometry", "http://www.w3.org/2001/XMLSchema#string"};
    private static final boolean[] bagParams = new boolean[3];

    public EventPointFunction(String functionName) {
        super(functionName, EventPointFunction.getId(functionName), params, bagParams, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_VISIBLE_AT);
        set.add(NAME_NOTVISIBLE_AT);
        return set;
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_VISIBLE_AT)) {
            return 0;
        }
        if (functionName.equals(NAME_NOTVISIBLE_AT)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown event function " + functionName);
    }

    @Override
    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        StringAttribute eventName = (StringAttribute)argValues[0];
        GeometryPointAttribute pointAttr = (GeometryPointAttribute)argValues[1];
        StringAttribute userName = (StringAttribute)argValues[2];
        Coordinate point = ((Point)pointAttr.getGeometry()).getCoordinate();
        Event ev = this.eventHandler.isEventVisibleAt(point, eventName.getValue(), userName.getValue());
        TimeAttribute reqTimeStamp = context.getCurrentTime();
        EvaluationDataBuffers.requestBuffer(reqTimeStamp).storeEvent(ev);
        boolean visible = ev != null;
        int funcId = this.getFunctionId();
        if (funcId == 0) {
            return EvaluationResult.getInstance(visible);
        }
        return EvaluationResult.getInstance(!visible);
    }
}

