/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.Expression;
import com.sun.xacml.cond.Function;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.FunctionTypeException;
import com.sun.xacml.cond.VariableReference;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class MapFunction
implements Function {
    public static final String NAME_MAP = "urn:oasis:names:tc:xacml:1.0:function:map";
    private URI returnType;
    private static URI identifier;
    private static RuntimeException earlyException;

    static {
        try {
            identifier = new URI(NAME_MAP);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }

    public MapFunction(URI returnType) {
        this.returnType = returnType;
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_MAP);
        return set;
    }

    public static MapFunction getInstance(Node root) throws ParsingException {
        URI returnType = null;
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("Function")) {
                String funcName = node.getAttributes().getNamedItem("FunctionId").getNodeValue();
                FunctionFactory factory = FunctionFactory.getGeneralInstance();
                try {
                    Function function = factory.createFunction(funcName);
                    returnType = function.getReturnType();
                    break;
                }
                catch (FunctionTypeException fte) {
                    try {
                        Function function = factory.createAbstractFunction(funcName, root);
                        returnType = function.getReturnType();
                        break;
                    }
                    catch (Exception e) {
                        throw new ParsingException("invalid abstract map", e);
                    }
                }
                catch (Exception e) {
                    throw new ParsingException("couldn't parse map body", e);
                }
            }
            ++i;
        }
        if (returnType == null) {
            throw new ParsingException("couldn't find the return type");
        }
        return new MapFunction(returnType);
    }

    @Override
    public URI getIdentifier() {
        if (earlyException != null) {
            throw earlyException;
        }
        return identifier;
    }

    @Override
    public URI getType() {
        return this.getReturnType();
    }

    @Override
    public URI getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean returnsBag() {
        return true;
    }

    private static EvaluationResult makeProcessingError(String message) {
        ArrayList<String> code = new ArrayList<String>();
        code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
        return new EvaluationResult(new Status(code, message));
    }

    @Override
    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        Iterator iterator = inputs.iterator();
        Function function = null;
        Expression xpr = (Expression)iterator.next();
        function = xpr instanceof Function ? (Function)xpr : (Function)((VariableReference)xpr).getReferencedDefinition().getExpression();
        Evaluatable eval = (Evaluatable)iterator.next();
        EvaluationResult result = eval.evaluate(context);
        if (result.indeterminate()) {
            return result;
        }
        BagAttribute bag = (BagAttribute)result.getAttributeValue();
        Iterator it = bag.iterator();
        ArrayList<AttributeValue> outputs = new ArrayList<AttributeValue>();
        while (it.hasNext()) {
            ArrayList params = new ArrayList();
            params.add(it.next());
            result = function.evaluate(params, context);
            if (result.indeterminate()) {
                return result;
            }
            outputs.add(result.getAttributeValue());
        }
        return new EvaluationResult(new BagAttribute(this.returnType, outputs));
    }

    @Override
    public void checkInputs(List inputs) throws IllegalArgumentException {
        Expression xpr;
        Object[] list = inputs.toArray();
        if (list.length != 2) {
            throw new IllegalArgumentException("map requires two inputs");
        }
        Function function = null;
        if (list[0] instanceof Function) {
            function = (Function)list[0];
        } else if (list[0] instanceof VariableReference && (xpr = ((VariableReference)list[0]).getReferencedDefinition().getExpression()) instanceof Function) {
            function = (Function)xpr;
        }
        if (function == null) {
            throw new IllegalArgumentException("first argument to map must be a Function");
        }
        Evaluatable eval = (Evaluatable)list[1];
        if (!eval.returnsBag()) {
            throw new IllegalArgumentException("second argument to map must be a bag");
        }
        ArrayList<Object> input = new ArrayList<Object>();
        input.add(list[1]);
        function.checkInputsNoBag(input);
    }

    @Override
    public void checkInputsNoBag(List inputs) throws IllegalArgumentException {
        throw new IllegalArgumentException("map requires a bag");
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        out.println(String.valueOf(indenter.makeString()) + "<Function FunctionId=\"" + NAME_MAP + "\"/>");
    }
}

