/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.BooleanAttribute;
import com.sun.xacml.attr.IntegerAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NOfFunction
extends FunctionBase {
    public static final String NAME_N_OF = "urn:oasis:names:tc:xacml:1.0:function:n-of";

    public NOfFunction(String functionName) {
        super(NAME_N_OF, 0, "http://www.w3.org/2001/XMLSchema#boolean", false);
        if (!functionName.equals(NAME_N_OF)) {
            throw new IllegalArgumentException("unknown nOf function: " + functionName);
        }
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_N_OF);
        return set;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        it = inputs.iterator();
        eval = (Evaluatable)it.next();
        result = eval.evaluate(context);
        if (result.indeterminate()) {
            return result;
        }
        n = ((IntegerAttribute)result.getAttributeValue()).getValue();
        if (n < 0L) {
            return NOfFunction.makeProcessingError("First argument to " + this.getFunctionName() + " cannot be negative.");
        }
        if (n == 0L) {
            return EvaluationResult.getTrueInstance();
        }
        remainingArgs = inputs.size() - 1;
        if (n <= remainingArgs) ** GOTO lbl21
        return NOfFunction.makeProcessingError("not enough arguments to n-of to find " + n + " true values");
lbl-1000:
        // 1 sources

        {
            eval = (Evaluatable)it.next();
            result = eval.evaluate(context);
            if (result.indeterminate()) {
                return result;
            }
            if (((BooleanAttribute)result.getAttributeValue()).getValue() && --n == 0L) {
                return EvaluationResult.getTrueInstance();
            }
            --remainingArgs;
lbl21:
            // 2 sources

            ** while (remainingArgs >= n)
        }
lbl22:
        // 1 sources

        return EvaluationResult.getFalseInstance();
    }

    @Override
    public void checkInputs(List inputs) throws IllegalArgumentException {
        Object[] list = inputs.toArray();
        int i = 0;
        while (i < list.length) {
            if (((Evaluatable)list[i]).returnsBag()) {
                throw new IllegalArgumentException("n-of can't use bags");
            }
            ++i;
        }
        this.checkInputsNoBag(inputs);
    }

    @Override
    public void checkInputsNoBag(List inputs) throws IllegalArgumentException {
        Object[] list = inputs.toArray();
        if (list.length == 0) {
            throw new IllegalArgumentException("n-of requires an argument");
        }
        Evaluatable eval = (Evaluatable)list[0];
        if (!eval.getType().toString().equals("http://www.w3.org/2001/XMLSchema#integer")) {
            throw new IllegalArgumentException("first argument to n-of must be an integer");
        }
        int i = 1;
        while (i < list.length) {
            if (!((Evaluatable)list[i]).getType().toString().equals("http://www.w3.org/2001/XMLSchema#boolean")) {
                throw new IllegalArgumentException("invalid parameter in n-of: expected boolean");
            }
            ++i;
        }
    }
}

