/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DateTimeAttribute;
import com.sun.xacml.attr.TimeExpressionAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class PeriodicExpressionFunction
extends FunctionBase {
    public static final String FUNCTION_NS = "urn:my:function:time:";
    public static final String NAME_INSIDE = "urn:my:function:time:inside";
    public static final String NAME_NOTINSIDE = "urn:my:function:time:not-inside";
    private static final int ID_INSIDE = 0;
    private static final int ID_NOTINSIDE = 1;
    private static final String[] params = new String[]{"http://www.w3.org/2001/XMLSchema#dateTime", "urn:my:periodic-expression"};
    private static final boolean[] bagParams = new boolean[2];

    public PeriodicExpressionFunction(String functionName) {
        super(functionName, PeriodicExpressionFunction.getId(functionName), params, bagParams, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_INSIDE);
        set.add(NAME_NOTINSIDE);
        return set;
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_INSIDE)) {
            return 0;
        }
        if (functionName.equals(NAME_NOTINSIDE)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown event function " + functionName);
    }

    private boolean checkCalendar(TreeSet<Integer>[] cals, int calIndex, GregorianCalendar requestCal) {
        switch (calIndex) {
            case 0: {
                return cals[calIndex].contains(requestCal.get(1));
            }
            case 1: {
                return cals[calIndex].contains(requestCal.get(2));
            }
            case 2: {
                if (cals[1] != null) {
                    return cals[calIndex].contains(requestCal.get(4));
                }
                return cals[calIndex].contains(requestCal.get(3));
            }
            case 3: {
                if (cals[2] != null) {
                    return cals[calIndex].contains(requestCal.get(7));
                }
                if (cals[1] != null) {
                    return cals[calIndex].contains(requestCal.get(5));
                }
                return cals[calIndex].contains(requestCal.get(6));
            }
        }
        return false;
    }

    private GregorianCalendar computeEndCal(GregorianCalendar startC, int calLengthIndex, int calLengthVal) {
        GregorianCalendar newC = new GregorianCalendar(startC.getTimeZone());
        newC.setTime(startC.getTime());
        switch (calLengthIndex) {
            case 0: {
                newC.add(1, calLengthVal);
                break;
            }
            case 1: {
                newC.add(2, calLengthVal);
                break;
            }
            case 2: {
                newC.add(3, calLengthVal);
                break;
            }
            case 3: {
                newC.add(6, calLengthVal);
                break;
            }
            case 4: {
                newC.add(11, calLengthVal);
            }
        }
        return newC;
    }

    private boolean requestInsidePeriod(TreeSet<Integer>[] cals, int smallestIndex, int calLengthIndex, int calLengthVal, GregorianCalendar requestCal) {
        GregorianCalendar startCal = new GregorianCalendar(requestCal.getTimeZone());
        Date requestTime = requestCal.getTime();
        startCal.setTime(requestTime);
        startCal.set(12, 0);
        startCal.set(13, 0);
        startCal.set(14, 0);
        switch (smallestIndex) {
            case 0: {
                startCal.set(2, 0);
                startCal.set(6, 1);
                startCal.set(11, 0);
                for (Integer val : cals[smallestIndex]) {
                    startCal.set(1, val);
                    if (!requestTime.after(startCal.getTime())) break;
                    GregorianCalendar endCal = this.computeEndCal(startCal, calLengthIndex, calLengthVal);
                    if (!requestTime.before(endCal.getTime())) continue;
                    return true;
                }
                return false;
            }
            case 1: {
                startCal.set(5, 1);
                startCal.set(11, 0);
                for (Integer val : cals[smallestIndex]) {
                    startCal.set(2, val);
                    if (!requestTime.after(startCal.getTime())) break;
                    GregorianCalendar endCal = this.computeEndCal(startCal, calLengthIndex, calLengthVal);
                    if (!requestTime.before(endCal.getTime())) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                startCal.set(7, 1);
                startCal.set(11, 0);
                for (Integer val : cals[smallestIndex]) {
                    if (cals[1] != null) {
                        startCal.set(4, val);
                    } else {
                        startCal.set(3, val);
                    }
                    if (!requestTime.after(startCal.getTime())) break;
                    GregorianCalendar endCal = this.computeEndCal(startCal, calLengthIndex, calLengthVal);
                    if (!requestTime.before(endCal.getTime())) continue;
                    return true;
                }
                return false;
            }
            case 3: {
                startCal.set(11, 0);
                for (Integer val : cals[smallestIndex]) {
                    if (cals[2] != null) {
                        startCal.set(7, val);
                    } else if (cals[1] != null) {
                        startCal.set(5, val);
                    } else {
                        startCal.set(6, val);
                    }
                    if (!requestTime.after(startCal.getTime())) break;
                    GregorianCalendar endCal = this.computeEndCal(startCal, calLengthIndex, calLengthVal);
                    if (!requestTime.before(endCal.getTime())) continue;
                    return true;
                }
                return false;
            }
            case 4: {
                for (Integer val : cals[smallestIndex]) {
                    startCal.set(11, val);
                    if (!requestTime.after(startCal.getTime())) break;
                    GregorianCalendar endCal = this.computeEndCal(startCal, calLengthIndex, calLengthVal);
                    if (!requestTime.before(endCal.getTime())) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        DateTimeAttribute dta = (DateTimeAttribute)argValues[0];
        TimeExpressionAttribute pea = (TimeExpressionAttribute)argValues[1];
        Date requestTime = dta.getValue();
        Date iStart = pea.getIntervalStart();
        Date iEnd = pea.getIntervalEnd();
        if (iStart != null && requestTime.before(iStart)) {
            return EvaluationResult.getFalseInstance();
        }
        if (iEnd != null && requestTime.after(iEnd)) {
            return EvaluationResult.getFalseInstance();
        }
        int lengthCalendarIndex = pea.getCalendarLengthIndex();
        int lengthCalendarValue = pea.getCalendarLengthValue();
        if (lengthCalendarIndex >= 0) {
            TreeSet<Integer>[] cals = pea.getStartDefinition();
            int smallest = lengthCalendarIndex;
            while (smallest >= 0) {
                if (cals[smallest] != null) break;
                --smallest;
            }
            GregorianCalendar requestCal = new GregorianCalendar(pea.getTimeZone());
            requestCal.setTime(requestTime);
            int i = 0;
            i = 0;
            while (i < smallest) {
                if (cals[i] != null && !this.checkCalendar(cals, i, requestCal)) break;
                ++i;
            }
            if (i < smallest) {
                return EvaluationResult.getFalseInstance();
            }
            boolean inside = this.requestInsidePeriod(cals, smallest, lengthCalendarIndex, lengthCalendarValue, requestCal);
            int funcId = this.getFunctionId();
            if (funcId == 0) {
                return EvaluationResult.getInstance(inside);
            }
            return EvaluationResult.getInstance(!inside);
        }
        return null;
    }
}

