/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.GeometryPointAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import com.sun.xacml.location.LocationHandler;
import com.sun.xacml.location.LocationLogical;
import com.sun.xacml.location.LocationType;
import com.vividsolutions.jts.geom.Coordinate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProximityFunction
extends FunctionBase {
    public static final String FUNCTION_NS = "urn:my:function:spatial:";
    public static final String NAME_ARE_NEAR = "urn:my:function:spatial:are-near";
    private static final int ID_ARE_NEAR = 0;

    public ProximityFunction(String functionName) {
        super(functionName, ProximityFunction.getId(functionName), "urn:ogc:def:dataType:geoxacml:1.0:geometry", false, 2, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_ARE_NEAR)) {
            return 0;
        }
        throw new IllegalArgumentException("unknown spatial function " + functionName);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_ARE_NEAR);
        return set;
    }

    @Override
    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        GeometryPointAttribute pointAttr1 = (GeometryPointAttribute)argValues[0];
        GeometryPointAttribute pointAttr2 = (GeometryPointAttribute)argValues[1];
        Coordinate point1 = pointAttr1.getGeometry().getCoordinate();
        Coordinate point2 = pointAttr2.getGeometry().getCoordinate();
        LocationHandler lh = LocationHandler.getInstance(null);
        HashSet<LocationLogical> llForPoint1 = new HashSet<LocationLogical>(lh.getLocationsContaining(point1));
        HashSet<LocationLogical> llForPoint2 = new HashSet<LocationLogical>(lh.getLocationsContaining(point2));
        HashSet<LocationLogical> commonLL = new HashSet<LocationLogical>(llForPoint1);
        commonLL.retainAll(llForPoint2);
        if (llForPoint1.size() == llForPoint2.size() && commonLL.size() == llForPoint1.size()) {
            return EvaluationResult.getTrueInstance();
        }
        if (commonLL.size() == 0) {
            return EvaluationResult.getFalseInstance();
        }
        HashSet<LocationType> commonLocTypes = new HashSet<LocationType>();
        Iterator<LocationLogical> llocsIt = commonLL.iterator();
        while (llocsIt.hasNext()) {
            commonLocTypes.add(llocsIt.next().getAssociatedType());
        }
        HashSet<LocationType> mappingTypes = new HashSet<LocationType>();
        llocsIt = llForPoint1.iterator();
        while (llocsIt.hasNext()) {
            mappingTypes.add(llocsIt.next().getAssociatedType());
        }
        llocsIt = llForPoint2.iterator();
        while (llocsIt.hasNext()) {
            mappingTypes.add(llocsIt.next().getAssociatedType());
        }
        Iterator commonLocsIt = commonLocTypes.iterator();
        HashSet remainingCommonLocs = new HashSet(commonLocTypes);
        block3: while (commonLocsIt.hasNext()) {
            LocationType currCommonType = (LocationType)commonLocsIt.next();
            Iterator mappingTypesIt = mappingTypes.iterator();
            while (mappingTypesIt.hasNext()) {
                if (lh.findRelationForTypes(currCommonType, (LocationType)mappingTypesIt.next()) <= 0) continue;
                remainingCommonLocs.remove(currCommonType);
                continue block3;
            }
        }
        if (remainingCommonLocs.size() > 0) {
            return EvaluationResult.getTrueInstance();
        }
        return EvaluationResult.getFalseInstance();
    }
}

