/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.RoleAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RoleFunction
extends FunctionBase {
    public static final String FUNCTION_NS = "urn:my:function:role:";
    public static final String NAME_IS_INSTANCE = "urn:my:function:role:is-instance";
    public static final String NAME_SAME_INSTANCE = "urn:my:function:role:same-instance";
    private static final int ID_IS_INSTANCE = 0;
    private static final int ID_SAME_INSTANCE = 1;

    public RoleFunction(String functionName) {
        super(functionName, RoleFunction.getId(functionName), "urn:my:dataType:role", false, 2, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_IS_INSTANCE)) {
            return 0;
        }
        if (functionName.equals(NAME_SAME_INSTANCE)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown spatial function " + functionName);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_IS_INSTANCE);
        set.add(NAME_SAME_INSTANCE);
        return set;
    }

    @Override
    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        RoleAttribute roleTemplate = (RoleAttribute)argValues[0];
        RoleAttribute roleInstance = (RoleAttribute)argValues[1];
        int funcId = this.getFunctionId();
        if (roleTemplate.getName().compareTo(roleInstance.getName()) != 0) {
            return EvaluationResult.getFalseInstance();
        }
        if (roleTemplate.getNumParams() != roleInstance.getNumParams()) {
            return EvaluationResult.getFalseInstance();
        }
        if (funcId == 0) {
            int numTemplateDefinedParamsType = roleTemplate.getParamTypes().size();
            if (numTemplateDefinedParamsType > 0) {
                boolean sameParams = roleTemplate.sameParamsType(roleInstance);
                return EvaluationResult.getInstance(sameParams);
            }
            return EvaluationResult.getTrueInstance();
        }
        if (funcId == 1) {
            boolean sameInstance = roleTemplate.sameParams(roleInstance);
            return EvaluationResult.getInstance(sameInstance);
        }
        return null;
    }
}

