/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.EvaluationDataBuffers;
import com.sun.xacml.MyBasicEvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.GeometryPointAttribute;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.attr.TimeAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import com.sun.xacml.location.LocationHandler;
import com.sun.xacml.location.LocationLogical;
import com.sun.xacml.location.LocationType;
import com.vividsolutions.jts.geom.Point;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SpatialFunction
extends FunctionBase {
    private LocationHandler locationHandler = LocationHandler.getInstance(null);
    public static final String FUNCTION_NS = "urn:my:function:spatial:";
    public static final String NAME_WITHIN_LOGICAL = "urn:my:function:spatial:point-within-location-logical";
    public static final String NAME_WITHIN_TYPE = "urn:my:function:spatial:point-within-location-type";
    public static final String NAME_NOTWITHIN_LOGICAL = "urn:my:function:spatial:point-not-within-location-logical";
    public static final String NAME_NOTWITHIN_TYPE = "urn:my:function:spatial:point-not-within-location-type";
    private static final int ID_WITHIN_LOGICAL = 0;
    private static final int ID_NOTWITHIN_LOGICAL = 1;
    private static final int ID_WITHIN_TYPE = 2;
    private static final int ID_NOTWITHIN_TYPE = 3;
    private static final String[] params = new String[]{"http://www.w3.org/2001/XMLSchema#string", "urn:ogc:def:dataType:geoxacml:1.0:geometry"};
    private static final boolean[] bagParams = new boolean[2];

    public SpatialFunction(String functionName) {
        super(functionName, SpatialFunction.getId(functionName), params, bagParams, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_WITHIN_LOGICAL)) {
            return 0;
        }
        if (functionName.equals(NAME_NOTWITHIN_LOGICAL)) {
            return 1;
        }
        if (functionName.equals(NAME_WITHIN_TYPE)) {
            return 2;
        }
        if (functionName.equals(NAME_NOTWITHIN_TYPE)) {
            return 3;
        }
        throw new IllegalArgumentException("unknown spatial function " + functionName);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_WITHIN_LOGICAL);
        set.add(NAME_NOTWITHIN_LOGICAL);
        set.add(NAME_WITHIN_TYPE);
        set.add(NAME_NOTWITHIN_TYPE);
        return set;
    }

    @Override
    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        TimeAttribute reqTimeStamp = context.getCurrentTime();
        StringAttribute locationName = (StringAttribute)argValues[0];
        GeometryPointAttribute pointAttr = (GeometryPointAttribute)argValues[1];
        Point point = (Point)pointAttr.getGeometry();
        int funcId = this.getFunctionId();
        if (funcId < 2) {
            List<LocationLogical> llocs;
            boolean isEnableRequest = true;
            if (context instanceof MyBasicEvaluationCtx) {
                llocs = ((MyBasicEvaluationCtx)context).getLogicalLocationsNamed(locationName.getValue());
                isEnableRequest = false;
            } else {
                llocs = this.locationHandler.findLocationsLogical(locationName.getValue());
            }
            boolean within = false;
            for (LocationLogical ll : llocs) {
                if (!ll.containsPoint(point)) continue;
                within = true;
                if (!isEnableRequest) break;
                EvaluationDataBuffers.requestBuffer(reqTimeStamp).storeLocation(ll);
                break;
            }
            result = funcId == 0 ? EvaluationResult.getInstance(within) : EvaluationResult.getInstance(!within);
        } else if (funcId >= 2 && funcId <= 4) {
            boolean within;
            LocationType lt = this.locationHandler.findLocationType(locationName.getValue());
            if (lt == null) {
                return EvaluationResult.getInstance(false);
            }
            boolean bl = within = lt.getLocationsContaining(point).size() != 0;
            if (within) {
                EvaluationDataBuffers.requestBuffer(reqTimeStamp).storeLocation(lt);
            }
            result = funcId == 2 ? EvaluationResult.getInstance(within) : EvaluationResult.getInstance(!within);
        }
        return result;
    }
}

