/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.PolicyMetaData;
import com.sun.xacml.cond.Expression;
import com.sun.xacml.cond.ExpressionHandler;
import com.sun.xacml.cond.VariableManager;
import java.io.OutputStream;
import java.io.PrintStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VariableDefinition {
    private String variableId;
    private Expression expression;

    public VariableDefinition(String variableId, Expression expression) {
        this.variableId = variableId;
        this.expression = expression;
    }

    public static VariableDefinition getInstance(Node root, PolicyMetaData metaData, VariableManager manager) throws ParsingException {
        String variableId = root.getAttributes().getNamedItem("VariableId").getNodeValue();
        NodeList nodes = root.getChildNodes();
        Node xprNode = nodes.item(0);
        int i = 1;
        while (xprNode.getNodeType() != 1) {
            xprNode = nodes.item(i++);
        }
        Expression xpr = ExpressionHandler.parseExpression(xprNode, metaData, manager);
        return new VariableDefinition(variableId, xpr);
    }

    public String getVariableId() {
        return this.variableId;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(String.valueOf(indent) + "<VariableDefinition VariableId=\"" + this.variableId + "\">");
        indenter.in();
        this.expression.encode(output, indenter);
        out.println("</VariableDefinition>");
        indenter.out();
    }
}

