/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.ctx;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DateTimeAttribute;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Attribute {
    private URI id;
    private URI type;
    private String issuer = null;
    private DateTimeAttribute issueInstant = null;
    private AttributeValue value;

    public Attribute(URI id, String issuer, DateTimeAttribute issueInstant, AttributeValue value) {
        this(id, value.getType(), issuer, issueInstant, value);
    }

    public Attribute(URI id, URI type, String issuer, DateTimeAttribute issueInstant, AttributeValue value) {
        this.id = id;
        this.type = type;
        this.issuer = issuer;
        this.issueInstant = issueInstant;
        this.value = value;
    }

    public static Attribute getInstance(Node root) throws ParsingException {
        URI id = null;
        URI type = null;
        String issuer = null;
        DateTimeAttribute issueInstant = null;
        AttributeValue value = null;
        AttributeFactory attrFactory = AttributeFactory.getInstance();
        if (!root.getNodeName().equals("Attribute")) {
            throw new ParsingException("Attribute object cannot be created with root node of type: " + root.getNodeName());
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            id = new URI(attrs.getNamedItem("AttributeId").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute AttributeId in AttributeType", e);
        }
        try {
            type = new URI(attrs.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required attribute DataType in AttributeType", e);
        }
        try {
            Node instantNode;
            Node issuerNode = attrs.getNamedItem("Issuer");
            if (issuerNode != null) {
                issuer = issuerNode.getNodeValue();
            }
            if ((instantNode = attrs.getNamedItem("IssueInstant")) != null) {
                issueInstant = DateTimeAttribute.getInstance(instantNode.getNodeValue());
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional AttributeType attribute", e);
        }
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("AttributeValue")) {
                if (value != null) {
                    throw new ParsingException("Too many values in Attribute");
                }
                try {
                    value = attrFactory.createValue(node, type);
                }
                catch (UnknownIdentifierException uie) {
                    throw new ParsingException("Unknown AttributeId", uie);
                }
            }
            ++i;
        }
        if (value == null) {
            throw new ParsingException("Attribute must contain a value");
        }
        return new Attribute(id, type, issuer, issueInstant, value);
    }

    public URI getId() {
        return this.id;
    }

    public URI getType() {
        return this.type;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public DateTimeAttribute getIssueInstant() {
        return this.issueInstant;
    }

    public AttributeValue getValue() {
        return this.value;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        String indent = indenter.makeString();
        PrintStream out = new PrintStream(output);
        out.println(String.valueOf(indent) + this.encode());
    }

    public String encode() {
        String encoded = "<Attribute AttributeId=\"" + this.id.toString() + "\" " + "DataType=\"" + this.type.toString() + "\"";
        if (this.issuer != null) {
            encoded = String.valueOf(encoded) + " Issuer=\"" + this.issuer + "\"";
        }
        if (this.issueInstant != null) {
            encoded = String.valueOf(encoded) + " IssueInstant=\"" + this.issueInstant.encode() + "\"";
        }
        encoded = String.valueOf(encoded) + ">" + this.value.encodeWithTags(false) + "</Attribute>";
        return encoded;
    }
}

