/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.ctx;

import com.sun.xacml.Indenter;
import com.sun.xacml.Obligation;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.event.Event;
import com.sun.xacml.location.LocationLogical;
import com.sun.xacml.location.LocationType;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EnablingResult
extends Result {
    private Map<String, List<Event>> events;
    private Map<String, List<Object>> locations;

    public EnablingResult(int decision, Map<String, List<Event>> events, Map<String, List<Object>> locations) throws IllegalArgumentException {
        super(decision);
        this.events = events;
        this.locations = locations;
    }

    public EnablingResult(int decision, Set obligations, Map<String, List<Event>> events, Map<String, List<Object>> locations) throws IllegalArgumentException {
        super(decision, obligations);
        this.events = events;
        this.locations = locations;
    }

    public EnablingResult(int decision, Status status, Map<String, List<Event>> events, Map<String, List<Object>> locations) throws IllegalArgumentException {
        super(decision, status);
        this.events = events;
        this.locations = locations;
    }

    public EnablingResult(int decision, Status status, Set obligations, Map<String, List<Event>> events, Map<String, List<Object>> locations) throws IllegalArgumentException {
        super(decision, status, obligations);
        this.events = events;
        this.locations = locations;
    }

    public EnablingResult(int decision, String resource, Map<String, List<Event>> events, Map<String, List<Object>> locations) throws IllegalArgumentException {
        super(decision, resource);
        this.events = events;
        this.locations = locations;
    }

    public EnablingResult(int decision, String resource, Set obligations, Map<String, List<Event>> events, Map<String, List<Object>> locations) throws IllegalArgumentException {
        super(decision, resource, obligations);
        this.events = events;
        this.locations = locations;
    }

    public EnablingResult(int decision, Status status, String resource, Map<String, List<Event>> events, Map<String, List<Object>> locations) throws IllegalArgumentException {
        super(decision, status, resource);
        this.events = events;
        this.locations = locations;
    }

    public EnablingResult(int decision, Status status, String resource, Set obligations, Map<String, List<Event>> events, Map<String, List<Object>> locations) throws IllegalArgumentException {
        super(decision, status, resource, obligations);
        this.events = events;
        this.locations = locations;
    }

    public Map<String, List<Event>> getEvents() {
        return this.events;
    }

    public Map<String, List<Object>> getLocations() {
        return this.locations;
    }

    @Override
    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    @Override
    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        indenter.in();
        String indentNext = indenter.makeString();
        if (this.getResource() == null) {
            out.println(String.valueOf(indent) + "<Result>");
        } else {
            out.println(String.valueOf(indent) + "<Result ResourceId=\"" + this.getResource() + "\">");
        }
        out.println(String.valueOf(indentNext) + "<Decision>" + DECISIONS[this.getDecision()] + "</Decision>");
        if (this.events != null && this.events.size() != 0) {
            Set<String> evNames = this.events.keySet();
            for (String evName : evNames) {
                Iterator<Event> evsIt = this.events.get(evName).iterator();
                while (evsIt.hasNext()) {
                    out.println(evsIt.next().encode());
                }
            }
        }
        if (this.locations != null && this.locations.size() != 0) {
            Set<String> locNames = this.locations.keySet();
            for (String locName : locNames) {
                for (Object loc : this.locations.get(locName)) {
                    if (loc instanceof LocationLogical) {
                        ((LocationLogical)loc).encode(output, indenter);
                    }
                    if (!(loc instanceof LocationType)) continue;
                    ((LocationType)loc).encodeOnlyName(output, indenter);
                }
            }
        }
        if (this.getStatus() != null) {
            this.getStatus().encode(output, indenter);
        }
        if (this.getObligations().size() != 0) {
            out.println(String.valueOf(indentNext) + "<Obligations>");
            Iterator it = this.getObligations().iterator();
            indenter.in();
            while (it.hasNext()) {
                Obligation obligation = (Obligation)it.next();
                obligation.encode(output, indenter);
            }
            indenter.out();
            out.println(String.valueOf(indentNext) + "</Obligations>");
        }
        indenter.out();
        out.println(String.valueOf(indent) + "</Result>");
    }
}

