/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.ctx;

import com.sun.xacml.ParsingException;
import java.io.File;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class InputParser
implements ErrorHandler {
    private File schemaFile;
    private static InputParser ipReference = null;
    private static final String CONTEXT_SCHEMA_PROPERTY = "com.sun.xacml.ContextSchema";
    private static final Logger logger = Logger.getLogger(InputParser.class.getName());
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    static {
        String schemaName = System.getProperty(CONTEXT_SCHEMA_PROPERTY);
        if (schemaName != null) {
            ipReference = new InputParser(new File(schemaName));
        }
    }

    private InputParser(File schemaFile) {
        this.schemaFile = schemaFile;
    }

    static Node parseInput(InputStream input, String rootTag) throws ParsingException {
        NodeList nodes = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            DocumentBuilder builder = null;
            factory.setNamespaceAware(true);
            if (ipReference == null) {
                factory.setValidating(false);
                builder = factory.newDocumentBuilder();
            } else {
                factory.setValidating(true);
                factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                factory.setAttribute(JAXP_SCHEMA_SOURCE, InputParser.ipReference.schemaFile);
                builder = factory.newDocumentBuilder();
                builder.setErrorHandler(ipReference);
            }
            Document doc = builder.parse(input);
            nodes = doc.getElementsByTagName(rootTag);
        }
        catch (Exception e) {
            throw new ParsingException("Error tring to parse " + rootTag + "Type", e);
        }
        if (nodes.getLength() != 1) {
            throw new ParsingException("Only one " + rootTag + "Type allowed " + "at the root of a Context doc");
        }
        return nodes.item(0);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Warning on line " + exception.getLineNumber() + ": " + exception.getMessage());
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Error on line " + exception.getLineNumber() + ": " + exception.getMessage());
        }
        throw new SAXException("invalid context document");
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("FatalError on line " + exception.getLineNumber() + ": " + exception.getMessage());
        }
        throw new SAXException("invalid context document");
    }
}

