/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.ctx;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.InputParser;
import com.sun.xacml.ctx.Subject;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestCtx {
    private Set subjects = null;
    private Set resource = null;
    private Set action = null;
    private Set environment = null;
    private Node documentRoot = null;
    private String resourceContent;

    public RequestCtx(Set subjects, Set resource, Set action, Set environment) {
        this(subjects, resource, action, environment, null, null);
    }

    public RequestCtx(Set subjects, Set resource, Set action, Set environment, Node documentRoot) {
        this(subjects, resource, action, environment, documentRoot, null);
    }

    public RequestCtx(Set subjects, Set resource, Set action, Set environment, String resourceContent) {
        this(subjects, resource, action, environment, null, resourceContent);
    }

    public RequestCtx(Set subjects, Set resource, Set action, Set environment, Node documentRoot, String resourceContent) throws IllegalArgumentException {
        Iterator sIter = subjects.iterator();
        while (sIter.hasNext()) {
            if (sIter.next() instanceof Subject) continue;
            throw new IllegalArgumentException("Subjects input is not well formed");
        }
        this.subjects = Collections.unmodifiableSet(new HashSet(subjects));
        Iterator rIter = resource.iterator();
        while (rIter.hasNext()) {
            if (rIter.next() instanceof Attribute) continue;
            throw new IllegalArgumentException("Resource input is not well formed");
        }
        this.resource = Collections.unmodifiableSet(new HashSet(resource));
        Iterator aIter = action.iterator();
        while (aIter.hasNext()) {
            if (aIter.next() instanceof Attribute) continue;
            throw new IllegalArgumentException("Action input is not well formed");
        }
        this.action = Collections.unmodifiableSet(new HashSet(action));
        Iterator eIter = environment.iterator();
        while (eIter.hasNext()) {
            if (eIter.next() instanceof Attribute) continue;
            throw new IllegalArgumentException("Environment input is not well formed");
        }
        this.environment = Collections.unmodifiableSet(new HashSet(environment));
        this.documentRoot = documentRoot;
        this.resourceContent = resourceContent;
    }

    public static RequestCtx getInstance(Node root) throws ParsingException {
        HashSet<Subject> newSubjects = new HashSet<Subject>();
        Set newResource = null;
        Set newAction = null;
        Set newEnvironment = null;
        String tagName = root.getNodeName();
        if (!tagName.equals("Request")) {
            throw new ParsingException("Request cannot be constructed using type: " + root.getNodeName());
        }
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            String tag = node.getNodeName();
            if (tag.equals("Subject")) {
                Node catNode = node.getAttributes().getNamedItem("SubjectCategory");
                URI category = null;
                if (catNode != null) {
                    try {
                        category = new URI(catNode.getNodeValue());
                    }
                    catch (Exception e) {
                        throw new ParsingException("Invalid Category URI", e);
                    }
                }
                Set attributes = RequestCtx.parseAttributes(node);
                newSubjects.add(new Subject(category, attributes));
            } else if (tag.equals("Resource")) {
                newResource = RequestCtx.parseAttributes(node);
            } else if (tag.equals("Action")) {
                newAction = RequestCtx.parseAttributes(node);
            } else if (tag.equals("Environment")) {
                newEnvironment = RequestCtx.parseAttributes(node);
            }
            ++i;
        }
        if (newEnvironment == null) {
            newEnvironment = new HashSet();
        }
        return new RequestCtx(newSubjects, newResource, newAction, newEnvironment, root);
    }

    private static Set parseAttributes(Node root) throws ParsingException {
        HashSet<Attribute> set = new HashSet<Attribute>();
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("Attribute")) {
                set.add(Attribute.getInstance(node));
            }
            ++i;
        }
        return set;
    }

    public static RequestCtx getInstance(InputStream input) throws ParsingException {
        return RequestCtx.getInstance(InputParser.parseInput(input, "Request"));
    }

    public Set getSubjects() {
        return this.subjects;
    }

    public Set getResource() {
        return this.resource;
    }

    public Set getAction() {
        return this.action;
    }

    public Set getEnvironmentAttributes() {
        return this.environment;
    }

    public Node getDocumentRoot() {
        return this.documentRoot;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String topIndent = indenter.makeString();
        out.println(String.valueOf(topIndent) + "<Request>");
        indenter.in();
        String indent = indenter.makeString();
        indenter.in();
        for (Subject subject : this.subjects) {
            out.print(String.valueOf(indent) + "<Subject SubjectCategory=\"" + subject.getCategory().toString() + "\"");
            Set subjectAttrs = subject.getAttributes();
            if (subjectAttrs.size() == 0) {
                out.println("/>");
                continue;
            }
            out.println(">");
            this.encodeAttributes(subjectAttrs, out, indenter);
            out.println(String.valueOf(indent) + "</Subject>");
        }
        if (this.resource.size() != 0 || this.resourceContent != null) {
            out.println(String.valueOf(indent) + "<Resource>");
            if (this.resourceContent != null) {
                out.println(String.valueOf(indenter.makeString()) + "<ResourceContent>" + this.resourceContent + "</ResourceContent>");
            }
            this.encodeAttributes(this.resource, out, indenter);
            out.println(String.valueOf(indent) + "</Resource>");
        } else {
            out.println(String.valueOf(indent) + "<Resource/>");
        }
        if (this.action.size() != 0) {
            out.println(String.valueOf(indent) + "<Action>");
            this.encodeAttributes(this.action, out, indenter);
            out.println(String.valueOf(indent) + "</Action>");
        } else {
            out.println(String.valueOf(indent) + "<Action/>");
        }
        if (this.environment.size() != 0) {
            out.println(String.valueOf(indent) + "<Environment>");
            this.encodeAttributes(this.environment, out, indenter);
            out.println(String.valueOf(indent) + "</Environment>");
        }
        indenter.out();
        indenter.out();
        out.println(String.valueOf(topIndent) + "</Request>");
    }

    private void encodeAttributes(Set attributes, PrintStream out, Indenter indenter) {
        for (Attribute attr : attributes) {
            attr.encode(out, indenter);
        }
    }
}

