/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.ctx;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.ctx.EnablingResult;
import com.sun.xacml.ctx.InputParser;
import com.sun.xacml.ctx.Result;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResponseCtx {
    private Set results = null;

    public ResponseCtx(Result result) {
        this.results = new HashSet();
        this.results.add(result);
    }

    public ResponseCtx(Set results) {
        this.results = Collections.unmodifiableSet(new HashSet(results));
    }

    public static ResponseCtx getInstance(Node root) throws ParsingException {
        HashSet<Result> results = new HashSet<Result>();
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("Result")) {
                results.add(Result.getInstance(node));
            }
            ++i;
        }
        if (results.size() == 0) {
            throw new ParsingException("must have at least one Result");
        }
        return new ResponseCtx(results);
    }

    public static ResponseCtx getInstance(InputStream input) throws ParsingException {
        return ResponseCtx.getInstance(InputParser.parseInput(input, "Response"));
    }

    public Set getResults() {
        return this.results;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(String.valueOf(indent) + "<Response>");
        Iterator it = this.results.iterator();
        indenter.in();
        while (it.hasNext()) {
            Result result = (Result)it.next();
            if (result instanceof EnablingResult) {
                EnablingResult res = (EnablingResult)result;
                res.encode(out, indenter);
                continue;
            }
            result.encode(out, indenter);
        }
        indenter.out();
        out.println(String.valueOf(indent) + "</Response>");
    }
}

