/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.ctx;

import com.sun.xacml.Indenter;
import com.sun.xacml.Obligation;
import com.sun.xacml.ParsingException;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Result {
    public static final int DECISION_PERMIT = 0;
    public static final int DECISION_DENY = 1;
    public static final int DECISION_INDETERMINATE = 2;
    public static final int DECISION_NOT_APPLICABLE = 3;
    public static final String[] DECISIONS = new String[]{"Permit", "Deny", "Indeterminate", "NotApplicable"};
    private int decision = -1;
    private Status status = null;
    private String resource = null;
    private Set obligations;

    public Result(int decision) throws IllegalArgumentException {
        this(decision, null, null, null);
    }

    public Result(int decision, Set obligations) throws IllegalArgumentException {
        this(decision, null, null, obligations);
    }

    public Result(int decision, Status status) throws IllegalArgumentException {
        this(decision, status, null, null);
    }

    public Result(int decision, Status status, Set obligations) throws IllegalArgumentException {
        this(decision, status, null, obligations);
    }

    public Result(int decision, String resource) throws IllegalArgumentException {
        this(decision, null, resource, null);
    }

    public Result(int decision, String resource, Set obligations) throws IllegalArgumentException {
        this(decision, null, resource, obligations);
    }

    public Result(int decision, Status status, String resource) throws IllegalArgumentException {
        this(decision, status, resource, null);
    }

    public Result(int decision, Status status, String resource, Set obligations) throws IllegalArgumentException {
        if (decision != 0 && decision != 1 && decision != 2 && decision != 3) {
            throw new IllegalArgumentException("invalid decision value");
        }
        this.decision = decision;
        this.resource = resource;
        this.status = status == null ? Status.getOkInstance() : status;
        this.obligations = obligations == null ? new HashSet() : obligations;
    }

    public static Result getInstance(Node root) throws ParsingException {
        int decision = -1;
        Status status = null;
        String resource = null;
        Set obligations = null;
        NamedNodeMap attrs = root.getAttributes();
        Node resourceAttr = attrs.getNamedItem("ResourceId");
        if (resourceAttr != null) {
            resource = resourceAttr.getNodeValue();
        }
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("Decision")) {
                String type = node.getFirstChild().getNodeValue();
                int j = 0;
                while (j < DECISIONS.length) {
                    if (DECISIONS[j].equals(type)) {
                        decision = j;
                        break;
                    }
                    ++j;
                }
                if (decision == -1) {
                    throw new ParsingException("Unknown Decision: " + type);
                }
            } else if (name.equals("Status")) {
                status = Status.getInstance(node);
            } else if (name.equals("Obligations")) {
                obligations = Result.parseObligations(node);
            }
            ++i;
        }
        return new Result(decision, status, resource, obligations);
    }

    private static Set parseObligations(Node root) throws ParsingException {
        HashSet<Obligation> set = new HashSet<Obligation>();
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("Obligation")) {
                set.add(Obligation.getInstance(node));
            }
            ++i;
        }
        if (set.size() == 0) {
            throw new ParsingException("ObligationsType must not be empty");
        }
        return set;
    }

    public int getDecision() {
        return this.decision;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean setResource(String resource) {
        if (this.resource != null) {
            return false;
        }
        this.resource = resource;
        return true;
    }

    public Set getObligations() {
        return this.obligations;
    }

    public void addObligation(Obligation obligation) {
        if (obligation != null) {
            this.obligations.add(obligation);
        }
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        indenter.in();
        String indentNext = indenter.makeString();
        if (this.resource == null) {
            out.println(String.valueOf(indent) + "<Result>");
        } else {
            out.println(String.valueOf(indent) + "<Result ResourceId=\"" + this.resource + "\">");
        }
        out.println(String.valueOf(indentNext) + "<Decision>" + DECISIONS[this.decision] + "</Decision>");
        if (this.status != null) {
            this.status.encode(output, indenter);
        }
        if (this.obligations.size() != 0) {
            out.println(String.valueOf(indentNext) + "<Obligations>");
            Iterator it = this.obligations.iterator();
            indenter.in();
            while (it.hasNext()) {
                Obligation obligation = (Obligation)it.next();
                obligation.encode(output, indenter);
            }
            indenter.out();
            out.println(String.valueOf(indentNext) + "</Obligations>");
        }
        indenter.out();
        out.println(String.valueOf(indent) + "</Result>");
    }
}

