/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.event;

import com.sun.xacml.event.Event;
import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EventGeneric
implements Event {
    public static final String TYPE = "generic";
    private int priority;
    private String userSubject;
    private String eventName;
    private String userTarget;
    private Coordinate position;
    private Date date;

    public EventGeneric() {
        this.priority = 0;
        this.userSubject = null;
        this.userTarget = null;
        this.position = null;
        this.eventName = "genericEvent";
        this.date = new Date();
    }

    public EventGeneric(int prios, String evName, String usrSubject, String usrTarget, Coordinate pos) {
        this.priority = prios;
        this.eventName = evName;
        this.userSubject = usrSubject;
        this.userTarget = usrTarget;
        this.position = pos;
        this.date = new Date();
    }

    public static EventGeneric getInstance(List attrsValue) {
        ArrayList attrs = new ArrayList(attrsValue);
        Integer prios = (Integer)attrs.get(0);
        return new EventGeneric(prios, (String)attrs.get(1), (String)attrs.get(2), (String)attrs.get(3), (Coordinate)attrs.get(4));
    }

    @Override
    public boolean isLocalized() {
        return this.position != null;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public Date getGenerationDate() {
        return this.date;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String generatedBy() {
        return this.userSubject;
    }

    @Override
    public String generatedFor() {
        return this.userTarget;
    }

    @Override
    public Coordinate generatedAtPosition() {
        return this.position;
    }

    public String toString() {
        String str = "Event named '" + this.eventName + "' of type " + TYPE + "(Prios:" + this.priority + ")";
        if (this.position != null) {
            str = String.valueOf(str) + ", generated at: (" + this.position.x + "," + this.position.y;
            if (!Double.isNaN(this.position.z)) {
                str = String.valueOf(str) + "," + this.position.z;
            }
            str = String.valueOf(str) + ")";
        }
        if (this.userSubject != null) {
            str = String.valueOf(str) + ",by user: " + this.userSubject;
        }
        if (this.userTarget != null) {
            str = String.valueOf(str) + ",for user: " + this.userTarget;
        }
        return str;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EventGeneric other = (EventGeneric)obj;
        return this.priority == other.priority && (this.eventName == other.eventName || this.eventName != null && this.eventName.equals(other.eventName)) && (this.userSubject == other.userSubject || this.userSubject != null && this.userSubject.equals(other.userSubject)) && (this.userTarget == other.userTarget || this.userTarget != null && this.userTarget.equals(other.userTarget)) && (this.position == other.position || this.position != null && this.position.equals((Object)other.position));
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.priority;
        hash = 31 * hash + this.eventName.hashCode();
        hash = 31 * hash + (this.userSubject == null ? 0 : this.userSubject.hashCode());
        hash = 31 * hash + (this.userTarget == null ? 0 : this.userTarget.hashCode());
        hash = 31 * hash + (this.position == null ? 0 : this.position.hashCode());
        return hash;
    }

    @Override
    public String encode() {
        String ret = "<Event>";
        ret = String.valueOf(ret) + "<Name>" + this.eventName + "</Name>";
        ret = String.valueOf(ret) + "<Priority>" + this.priority + "</Priority>";
        if (this.position == null) {
            ret = String.valueOf(ret) + "<GenerationPoint />";
        } else {
            ret = String.valueOf(ret) + "<GenerationPoint>" + this.position.x + " " + this.position.y;
            if (!Double.isNaN(this.position.z)) {
                ret = String.valueOf(ret) + " " + this.position.z;
            }
            ret = String.valueOf(ret) + "</GenerationPoint>";
        }
        ret = this.userSubject == null ? String.valueOf(ret) + "<GeneratedBy />" : String.valueOf(ret) + "<GeneratedBy>" + this.userSubject + "</GeneratedBy>";
        ret = this.userTarget == null ? String.valueOf(ret) + "<GeneratedFor />" : String.valueOf(ret) + "<GeneratedFor>" + this.userTarget + "</GeneratedFor>";
        ret = String.valueOf(ret) + "</Event>";
        return ret;
    }
}

