/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.event;

import com.sun.xacml.attr.TimeAttribute;
import com.sun.xacml.event.Event;
import com.sun.xacml.event.EventFactory;
import com.sun.xacml.event.EventGenericProxy;
import com.sun.xacml.location.LocationHandler;
import com.sun.xacml.location.LocationLogical;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class EventHandler {
    private HashMap<String, LinkedList<Event>> localizedEvents = new HashMap();
    private HashMap<String, LinkedList<Event>> globalEvents;
    private static EventHandler ehInstance = null;
    private EventFactory eventFactory;

    public EventHandler(EventFactory evFactory) {
        this.eventFactory = evFactory;
        this.globalEvents = new HashMap();
    }

    public EventHandler() {
        this.eventFactory = new EventFactory();
        this.globalEvents = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventHandler getInstance() {
        if (ehInstance != null) return ehInstance;
        Class<EventHandler> clazz = EventHandler.class;
        synchronized (EventHandler.class) {
            if (ehInstance != null) return ehInstance;
            ehInstance = new EventHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ehInstance;
        }
    }

    public EventFactory getEventFactory() {
        return this.eventFactory;
    }

    public void setEventFactory(EventFactory evFactory) {
        this.eventFactory = evFactory;
    }

    private void orderedInsertion(Event newEv, LinkedList<Event> list) {
        int newEvPrios = newEv.getPriority();
        if (list.size() == 0) {
            list.add(newEv);
            return;
        }
        int i = 0;
        i = 0;
        while (i < list.size()) {
            int currEvPrios = list.get(i).getPriority();
            if (newEvPrios >= currEvPrios) {
                list.add(i, newEv);
                break;
            }
            ++i;
        }
        if (i == list.size()) {
            list.add(newEv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event createEvent(String type, List attrs) {
        Event newEv = this.eventFactory.createEvent(type, attrs);
        Class<EventHandler> clazz = EventHandler.class;
        synchronized (EventHandler.class) {
            HashMap<String, LinkedList<Event>> map = newEv.isLocalized() ? this.localizedEvents : this.globalEvents;
            String evName = newEv.getEventName();
            if (!map.containsKey(evName)) {
                map.put(evName, new LinkedList());
            }
            this.orderedInsertion(newEv, map.get(evName));
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return newEv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEvent(String type, List attrs) {
        Event temp = this.eventFactory.createEvent(type, attrs);
        if (temp == null) {
            return false;
        }
        Class<EventHandler> clazz = EventHandler.class;
        synchronized (EventHandler.class) {
            HashMap<String, LinkedList<Event>> map;
            block5: {
                map = temp.isLocalized() ? this.localizedEvents : this.globalEvents;
                if (map.get(temp.getEventName()) != null) break block5;
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return map.get(temp.getEventName()).remove(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event isEventVisibleAt(Coordinate pos, String evName, String usrName) {
        LinkedList gEvents = null;
        LinkedList lEvents = null;
        Event gEvent = null;
        Class<EventHandler> clazz = EventHandler.class;
        synchronized (EventHandler.class) {
            if (this.globalEvents.get(evName) != null) {
                gEvents = new LinkedList(this.globalEvents.get(evName));
            }
            if (this.localizedEvents.get(evName) != null) {
                lEvents = new LinkedList(this.localizedEvents.get(evName));
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (gEvents != null) {
                for (Event currEv : gEvents) {
                    if (currEv.generatedFor() != null && !currEv.generatedFor().equals(usrName)) continue;
                    gEvent = currEv;
                    break;
                }
            }
            if (gEvent != null && (lEvents == null || gEvent.getPriority() >= ((Event)lEvents.getFirst()).getPriority())) {
                return gEvent;
            }
            if (lEvents != null) {
                for (Event currEv : lEvents) {
                    if (currEv.generatedFor() != null && !currEv.generatedFor().equals(usrName) || !this.isLocalizedEventVisibleAt(pos, currEv)) continue;
                    return currEv;
                }
            }
            return gEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event isEventGeneratedByVisibleAt(Coordinate pos, String evName, String usrName, String generatingUser) {
        LinkedList gEvents = null;
        LinkedList lEvents = null;
        Event gEvent = null;
        Class<EventHandler> clazz = EventHandler.class;
        synchronized (EventHandler.class) {
            if (this.globalEvents.get(evName) != null) {
                gEvents = new LinkedList(this.globalEvents.get(evName));
            }
            if (this.localizedEvents.get(evName) != null) {
                lEvents = new LinkedList(this.localizedEvents.get(evName));
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (gEvents != null) {
                for (Event currEv : gEvents) {
                    if (currEv.generatedFor() != null && !currEv.generatedFor().equals(usrName) || currEv.generatedBy() == null || !currEv.generatedBy().equals(generatingUser)) continue;
                    gEvent = currEv;
                    break;
                }
            }
            if (gEvent != null && (lEvents == null || gEvent.getPriority() >= ((Event)lEvents.getFirst()).getPriority())) {
                return gEvent;
            }
            if (lEvents != null) {
                for (Event currEv : lEvents) {
                    if (currEv.generatedFor() != null && !currEv.generatedFor().equals(usrName) || currEv.generatedBy() == null || !currEv.generatedBy().equals(generatingUser) || !this.isLocalizedEventVisibleAt(pos, currEv)) continue;
                    return currEv;
                }
            }
            return gEvent;
        }
    }

    private boolean isLocalizedEventVisibleAt(Coordinate pos, Event locEvent) {
        Coordinate evPoint;
        LocationHandler lh = LocationHandler.getInstance(null);
        List<LocationLogical> locs = lh.getLocationsContainingPoints(pos, evPoint = locEvent.generatedAtPosition());
        return locs.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event isEventVisibleIn(LocationLogical loc, String evName, String usrName) {
        LinkedList gEvents = null;
        LinkedList lEvents = null;
        Event gEvent = null;
        Class<EventHandler> clazz = EventHandler.class;
        synchronized (EventHandler.class) {
            if (this.globalEvents.get(evName) != null) {
                gEvents = new LinkedList(this.globalEvents.get(evName));
            }
            if (this.localizedEvents.get(evName) != null) {
                lEvents = new LinkedList(this.localizedEvents.get(evName));
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (gEvents != null) {
                for (Event currEv : gEvents) {
                    if (currEv.generatedFor() != null && !currEv.generatedFor().equals(usrName)) continue;
                    gEvent = currEv;
                    break;
                }
            }
            if (gEvent != null && (lEvents == null || gEvent.getPriority() >= ((Event)lEvents.getFirst()).getPriority())) {
                return gEvent;
            }
            if (lEvents != null) {
                for (Event currEv : lEvents) {
                    Point generationPoint;
                    if (currEv.generatedFor() != null && !currEv.generatedFor().equals(usrName) || !loc.containsPoint(generationPoint = LocationHandler.getInstance(null).createPoint(currEv.generatedAtPosition()))) continue;
                    return currEv;
                }
            }
            return gEvent;
        }
    }

    public List<Event> getAllEventsNamed(String evName) {
        LinkedList<Event> res = new LinkedList<Event>();
        if (this.globalEvents.get(evName) != null) {
            res.addAll((Collection)this.globalEvents.get(evName));
        }
        if (this.localizedEvents.get(evName) != null) {
            res.addAll((Collection<Event>)this.localizedEvents.get(evName));
        }
        return res;
    }

    public void erase() {
        ehInstance = null;
    }

    public static void main(String[] args) {
        LocationHandler lh = LocationHandler.getInstance(0);
        lh.addLocationType("tipo");
        Coordinate[] c1 = new Coordinate[]{new Coordinate(-2.0, 2.0), new Coordinate(4.0, 2.0), new Coordinate(4.0, 5.0), new Coordinate(-2.0, 5.0), new Coordinate(-2.0, 2.0)};
        lh.createLogicalPolygon("a1", "tipo", c1, null);
        Coordinate[] c2 = new Coordinate[]{new Coordinate(0.0, 3.0), new Coordinate(3.0, 3.0), new Coordinate(1.5, 7.0), new Coordinate(0.0, 3.0)};
        lh.createLogicalPolygon("a2", "tipo", c2, null);
        Coordinate[] c3 = new Coordinate[]{new Coordinate(6.0, 1.0), new Coordinate(7.0, 1.0), new Coordinate(7.0, 2.0), new Coordinate(6.0, 2.0), new Coordinate(6.0, 1.0)};
        lh.createLogicalPolygon("a3", "tipo", c3, null);
        Coordinate[] c4 = new Coordinate[]{new Coordinate(5.0, 1.0), new Coordinate(7.0, 1.0), new Coordinate(7.0, 3.0), new Coordinate(5.0, 1.0)};
        lh.createLogicalPolygon("a4", "tipo", c4, null);
        EventHandler eh = new EventHandler();
        eh.getEventFactory().addEventType("generic", new EventGenericProxy());
        List param1 = EventGenericProxy.constructParameterList(0, "prova", "utente", "user1", new Coordinate(1.5, 6.0));
        eh.createEvent("generic", param1);
        TimeAttribute ts = new TimeAttribute();
        Event ev = eh.isEventVisibleAt(new Coordinate(1.5, 5.2), "prova", "utente");
    }
}

