/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.finder;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.PolicyMetaData;
import com.sun.xacml.VersionConstraints;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.PolicyFinderResult;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PolicyFinder {
    private Set allModules;
    private Set requestModules;
    private Set referenceModules;
    private static final Logger logger = Logger.getLogger(PolicyFinder.class.getName());

    public Set getModules() {
        return new HashSet(this.allModules);
    }

    public void setModules(Set modules) {
        Iterator it = modules.iterator();
        this.allModules = new HashSet(modules);
        this.requestModules = new HashSet();
        this.referenceModules = new HashSet();
        while (it.hasNext()) {
            PolicyFinderModule module = (PolicyFinderModule)it.next();
            if (module.isRequestSupported()) {
                this.requestModules.add(module);
            }
            if (!module.isIdReferenceSupported()) continue;
            this.referenceModules.add(module);
        }
    }

    public void init() {
        logger.finer("Initializing PolicyFinder");
        for (PolicyFinderModule module : this.allModules) {
            module.init(this);
        }
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        PolicyFinderResult result = null;
        for (PolicyFinderModule module : this.requestModules) {
            PolicyFinderResult newResult = module.findPolicy(context);
            if (newResult.indeterminate()) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("An error occured while trying to find a single applicable policy for a request: " + newResult.getStatus().getMessage());
                }
                return newResult;
            }
            if (newResult.notApplicable()) continue;
            if (result != null) {
                logger.info("More than one top-level applicable policy for the request");
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            result = newResult;
        }
        if (result != null) {
            return result;
        }
        logger.info("No applicable policies were found for the request");
        return new PolicyFinderResult();
    }

    /*
     * Unable to fully structure code
     */
    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) throws IllegalArgumentException {
        result = null;
        it = this.referenceModules.iterator();
        if (type == 0 || type == 1) ** GOTO lbl21
        throw new IllegalArgumentException("Unknown reference type");
lbl-1000:
        // 1 sources

        {
            module = (PolicyFinderModule)it.next();
            newResult = module.findPolicy(idReference, type, constraints, parentMetaData);
            if (newResult.indeterminate()) {
                if (PolicyFinder.logger.isLoggable(Level.INFO)) {
                    PolicyFinder.logger.info("An error occured while trying to find the referenced policy " + idReference.toString() + ": " + newResult.getStatus().getMessage());
                }
                return newResult;
            }
            if (newResult.notApplicable()) continue;
            if (result != null) {
                if (PolicyFinder.logger.isLoggable(Level.INFO)) {
                    PolicyFinder.logger.info("More than one policy applies for the reference: " + idReference.toString());
                }
                code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                status = new Status(code, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            result = newResult;
lbl21:
            // 3 sources

            ** while (it.hasNext())
        }
lbl22:
        // 1 sources

        if (result != null) {
            return result;
        }
        if (PolicyFinder.logger.isLoggable(Level.INFO)) {
            PolicyFinder.logger.info("No policies were resolved for the reference: " + idReference.toString());
        }
        return new PolicyFinderResult();
    }
}

