/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.finder.impl;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.RoleAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.finder.AttributeFinderModule;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;

public class RoleParameterModule
extends AttributeFinderModule {
    public static final String PARAMETER_ATTR_ID_PREFIX = "urn:my:parameter:";

    @Override
    public boolean isDesignatorSupported() {
        return true;
    }

    @Override
    public EvaluationResult findAttribute(URI attributeType, URI attributeId, URI issuer, URI subjectCategory, EvaluationCtx context, int designatorType) {
        EvaluationResult roleResult;
        String attrId = attributeId.toString();
        if (!attrId.contains(PARAMETER_ATTR_ID_PREFIX)) {
            return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
        }
        String paramName = attrId.substring(attrId.lastIndexOf(":") + 1);
        try {
            roleResult = context.getSubjectAttribute(new URI("urn:my:dataType:role"), new URI("urn:oasis:names:tc:xacml:2.0:subject:role"), subjectCategory);
        }
        catch (URISyntaxException e) {
            return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
        }
        BagAttribute resBag = (BagAttribute)roleResult.getAttributeValue();
        if (resBag.size() == 0) {
            return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
        }
        Iterator resBagIt = resBag.iterator();
        RoleAttribute roleAttr = null;
        while (resBagIt.hasNext()) {
            Object currEl = resBagIt.next();
            if (!(currEl instanceof RoleAttribute)) continue;
            roleAttr = (RoleAttribute)currEl;
            break;
        }
        if (roleAttr == null) {
            return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
        }
        AttributeValue paramValue = roleAttr.getParams().get(paramName);
        if (paramValue == null) {
            return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
        }
        return this.makeBag(paramValue);
    }

    private EvaluationResult makeBag(AttributeValue attribute) {
        HashSet<AttributeValue> set = new HashSet<AttributeValue>();
        set.add(attribute);
        BagAttribute bag = new BagAttribute(attribute.getType(), set);
        return new EvaluationResult(bag);
    }
}

