/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.finder.impl;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.AttributeFinderModule;
import java.net.URI;
import java.util.ArrayList;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectorModule
extends AttributeFinderModule {
    @Override
    public boolean isSelectorSupported() {
        return true;
    }

    private EvaluationResult createProcessingError(String msg) {
        ArrayList<String> code = new ArrayList<String>();
        code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
        return new EvaluationResult(new Status(code, msg));
    }

    @Override
    public EvaluationResult findAttribute(String path, Node namespaceNode, URI type, EvaluationCtx context, String xpathVersion) {
        int i;
        if (!xpathVersion.equals("http://www.w3.org/TR/1999/Rec-xpath-19991116")) {
            return new EvaluationResult(BagAttribute.createEmptyBag(type));
        }
        Node root = context.getRequestRoot();
        Node nsNode = namespaceNode != null ? namespaceNode : root;
        String rootPath = "";
        if (path.charAt(0) != '/') {
            String rootName = root.getLocalName();
            String namespace = root.getNamespaceURI();
            if (namespace == null) {
                rootPath = "/" + rootName + "/";
            } else {
                NamedNodeMap nmap = namespaceNode.getAttributes();
                rootPath = null;
                i = 0;
                while (i < nmap.getLength()) {
                    Node n = nmap.item(i);
                    if (n.getNodeValue().equals(namespace)) {
                        String name = n.getNodeName();
                        int pos = name.indexOf(58);
                        rootPath = pos == -1 ? "/" : "/" + name.substring(pos + 1);
                        rootPath = String.valueOf(rootPath) + ":" + rootName + "/";
                        break;
                    }
                    ++i;
                }
                if (rootPath == null) {
                    return this.createProcessingError("Failed to map a namespace in an XPath expression");
                }
            }
        }
        NodeList matches = null;
        try {
            matches = XPathAPI.selectNodeList((Node)root, (String)(String.valueOf(rootPath) + path), (Node)nsNode);
        }
        catch (Exception e) {
            return this.createProcessingError("error in XPath: " + e.getMessage());
        }
        if (matches.getLength() == 0) {
            return new EvaluationResult(BagAttribute.createEmptyBag(type));
        }
        try {
            ArrayList<AttributeValue> list = new ArrayList<AttributeValue>();
            AttributeFactory attrFactory = AttributeFactory.getInstance();
            i = 0;
            while (i < matches.getLength()) {
                String text = null;
                Node node = matches.item(i);
                short nodeType = node.getNodeType();
                text = nodeType == 4 || nodeType == 8 || nodeType == 3 || nodeType == 2 ? node.getNodeValue() : node.getFirstChild().getNodeValue();
                list.add(attrFactory.createValue(type, text));
                ++i;
            }
            return new EvaluationResult(new BagAttribute(type, list));
        }
        catch (ParsingException pe) {
            return this.createProcessingError(pe.getMessage());
        }
        catch (UnknownIdentifierException uie) {
            return this.createProcessingError("unknown attribute type: " + type);
        }
    }
}

