/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.location;

import com.sun.xacml.location.LocationLogical;
import com.sun.xacml.location.LocationNode;
import com.sun.xacml.location.LocationType;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import intervalTree.IntervalTree;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class LocationHandler {
    private static LocationHandler handlerInstance = null;
    private int srID;
    private GeometryFactory geometryFactory;
    private HashMap<String, LocationType> locTypes;
    private HashMap<String, LinkedList<LocationLogical>> logicalLocs;
    private IntervalTree<LocationLogical> xITree;
    private IntervalTree<LocationLogical> yITree;

    public LocationHandler(int srID) {
        this.geometryFactory = new GeometryFactory(new PrecisionModel(), srID);
        this.locTypes = new HashMap();
        this.logicalLocs = new HashMap();
        this.xITree = new IntervalTree();
        this.yITree = new IntervalTree();
        this.srID = srID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocationHandler getInstance(Integer srID) {
        if (handlerInstance != null) return handlerInstance;
        Class<LocationHandler> clazz = LocationHandler.class;
        synchronized (LocationHandler.class) {
            if (handlerInstance != null) return handlerInstance;
            if (srID == null) {
                srID = 0;
            }
            handlerInstance = new LocationHandler(srID);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return handlerInstance;
        }
    }

    public LocationType findLocationType(String typeName) {
        return this.locTypes.get(typeName);
    }

    public boolean addLocationType(String typeName) {
        if (this.findLocationType(typeName) != null) {
            return false;
        }
        this.locTypes.put(typeName, new LocationType(typeName));
        return true;
    }

    public boolean addLocationType(String typeName, Map<String, LocationNode> subTypes) {
        if (this.findLocationType(typeName) != null) {
            return false;
        }
        this.locTypes.put(typeName, new LocationType(typeName, subTypes));
        return true;
    }

    public boolean addTypeRelation(String hTypeName, String[] lTypes) {
        LocationType highT = this.findLocationType(hTypeName);
        if (highT == null) {
            return false;
        }
        int i = 0;
        while (i < lTypes.length) {
            LocationType lowT = this.findLocationType(lTypes[i]);
            if (lowT != null) {
                highT.addLink(lowT);
            }
            ++i;
        }
        return true;
    }

    public void resetNodeTypeColours() {
        Vector<LocationType> types = new Vector<LocationType>(this.locTypes.values());
        int i = 0;
        while (i < types.size()) {
            types.get(i).setColor(0);
            ++i;
        }
    }

    public int findRelationForTypes(String t1, String t2) {
        LocationType lt1 = this.locTypes.get(t1);
        LocationType lt2 = this.locTypes.get(t2);
        return this.findRelationForTypes(lt1, lt2);
    }

    public int findRelationForTypes(LocationType t1, LocationType t2) {
        if (t1 == null || t2 == null) {
            return -2;
        }
        if (t1.isTopInstance() && t2.isTopInstance()) {
            return 0;
        }
        if (t1.isTopInstance() && !t2.isTopInstance()) {
            return 1;
        }
        if (!t1.isTopInstance() && t2.isTopInstance()) {
            return -1;
        }
        this.resetNodeTypeColours();
        if (this.verifyPath(t1, t2)) {
            return 1;
        }
        this.resetNodeTypeColours();
        if (this.verifyPath(t2, t1)) {
            return -1;
        }
        return 0;
    }

    public boolean verifyPath(LocationNode start, LocationNode end) {
        boolean found = false;
        if (start.isLinkedTo(end.getName())) {
            found = true;
        }
        if (!found) {
            start.setColor(0);
            Vector<LocationNode> adj = start.getAdjacents();
            int i = 0;
            while (i < adj.size()) {
                if (adj.get(i).getColour() == 0) {
                    found = this.verifyPath(adj.get(i), end) || found;
                }
                ++i;
            }
            start.setColor(0);
        }
        return found;
    }

    public LocationType getTypeUniverseInstance() {
        return LocationType.getTopInstance();
    }

    private void insertLogicalLocation(LinkedList<LocationLogical> list, LocationLogical ll) {
        if (list == null) {
            LinkedList<LocationLogical> newList = new LinkedList<LocationLogical>();
            newList.add(ll);
            this.logicalLocs.put(ll.getName(), newList);
        } else {
            list.add(ll);
        }
    }

    public boolean createLogicalLocation(String llName, String assType, Geometry geom) {
        if (!(geom instanceof LinearRing) && !(geom instanceof Polygon)) {
            return false;
        }
        LocationType associated = this.findLocationType(assType);
        if (associated == null) {
            return false;
        }
        LocationLogical newLLoc = new LocationLogical(geom, llName, associated);
        this.insertLogicalLocation(this.logicalLocs.get(llName), newLLoc);
        associated.addAssociationToLogicalLoc(newLLoc);
        this.insertLLocationDataInTrees(newLLoc);
        return true;
    }

    public boolean createLogicalRing(String llName, String ltName, Coordinate[] coords) {
        LinearRing ring = this.geometryFactory.createLinearRing(coords);
        return this.createLogicalLocation(llName, ltName, (Geometry)ring);
    }

    public boolean createLogicalPolygon(String llName, String ltName, Coordinate[] extRingCoords, Collection<Coordinate[]> intRingsCoords) {
        LinearRing extRing = this.geometryFactory.createLinearRing(extRingCoords);
        LinearRing[] intRings = null;
        if (intRingsCoords != null) {
            intRings = new LinearRing[intRingsCoords.size()];
            Iterator<Coordinate[]> it = intRingsCoords.iterator();
            int i = 0;
            while (it.hasNext()) {
                intRings[i] = this.geometryFactory.createLinearRing(it.next());
                ++i;
            }
        }
        Polygon newPol = this.geometryFactory.createPolygon(extRing, intRings);
        return this.createLogicalLocation(llName, ltName, (Geometry)newPol);
    }

    public List<LocationLogical> findLocationsLogical(String name) {
        return this.logicalLocs.get(name);
    }

    public List<LocationLogical> getLocationsContaining(Coordinate p) {
        HashSet<LocationLogical> llocsForX = new HashSet<LocationLogical>(this.xITree.get(p.x));
        HashSet<LocationLogical> llocsForY = new HashSet<LocationLogical>(this.yITree.get(p.y));
        Point point = this.createPoint(p);
        LinkedList<LocationLogical> result = new LinkedList<LocationLogical>();
        for (LocationLogical ll : llocsForX) {
            if (!llocsForY.contains(ll) || !ll.getGeometry().contains((Geometry)point)) continue;
            result.add(ll);
        }
        return result;
    }

    public List<LocationLogical> getLocationsContainingPoints(Coordinate p1, Coordinate p2) {
        HashSet<LocationLogical> llocsForX = new HashSet<LocationLogical>(this.xITree.getContainers(p1.x, p2.x));
        HashSet<LocationLogical> llocsForY = new HashSet<LocationLogical>(this.yITree.getContainers(p1.y, p2.y));
        LinkedList<LocationLogical> result = new LinkedList<LocationLogical>();
        Point point1 = this.geometryFactory.createPoint(p1);
        Point point2 = this.geometryFactory.createPoint(p2);
        for (LocationLogical ll : llocsForX) {
            if (!llocsForY.contains(ll) || !ll.getGeometry().contains((Geometry)point1) || !ll.getGeometry().contains((Geometry)point2)) continue;
            result.add(ll);
        }
        return result;
    }

    public int findRelationForLogicalLocs(LocationLogical l1, LocationLogical l2) {
        if (l1 == null | l2 == null) {
            return -2;
        }
        return this.findRelationForTypes(l1.getAssociatedType(), l2.getAssociatedType());
    }

    public LocationLogical getLogicalUniverseInstance() {
        return LocationLogical.getUniverseLocation();
    }

    private void insertLLocationDataInTrees(LocationLogical ll) {
        Envelope env = ll.getGeometry().getEnvelopeInternal();
        this.xITree.addInterval(env.getMinX(), env.getMaxX(), ll);
        this.yITree.addInterval(env.getMinY(), env.getMaxY(), ll);
    }

    public void rebuildTrees() {
        this.xITree = new IntervalTree();
        this.yITree = new IntervalTree();
        LinkedList<LinkedList<LocationLogical>> llocs = new LinkedList<LinkedList<LocationLogical>>(this.logicalLocs.values());
        for (LinkedList linkedList : llocs) {
            for (LocationLogical ll : linkedList) {
                this.insertLLocationDataInTrees(ll);
            }
        }
        this.xITree.build();
        this.yITree.build();
    }

    public int findRelationBetween(Object loc1, Object loc2) {
        if (!(loc1 instanceof LocationType) && !(loc1 instanceof LocationLogical)) {
            return -2;
        }
        if (!(loc2 instanceof LocationType) && !(loc2 instanceof LocationLogical)) {
            return -2;
        }
        if (loc1 instanceof LocationType && loc2 instanceof LocationType) {
            return this.findRelationForTypes((LocationType)loc1, (LocationType)loc2);
        }
        if (loc1 instanceof LocationLogical && loc2 instanceof LocationLogical) {
            return this.findRelationForLogicalLocs((LocationLogical)loc1, (LocationLogical)loc2);
        }
        if (loc1 instanceof LocationLogical) {
            LocationType otherType = ((LocationLogical)loc1).getAssociatedType();
            return this.findRelationForTypes(otherType, (LocationType)loc2);
        }
        LocationType otherType = ((LocationLogical)loc2).getAssociatedType();
        return this.findRelationForTypes((LocationType)loc1, otherType);
    }

    public List findLocationNamed(String name) {
        LocationType loc = this.findLocationType(name);
        if (loc != null) {
            LinkedList<LocationType> locs = new LinkedList<LocationType>();
            locs.add(loc);
            return locs;
        }
        return this.findLocationsLogical(name);
    }

    public Point createPoint(Coordinate coord) {
        return this.geometryFactory.createPoint(coord);
    }

    public void erase() {
        handlerInstance = null;
    }

    public static void main(String[] args) {
        LocationHandler lh = new LocationHandler(0);
        lh.addLocationType("tipo");
        Coordinate[] c1 = new Coordinate[]{new Coordinate(-2.0, 2.0), new Coordinate(4.0, 2.0), new Coordinate(4.0, 5.0), new Coordinate(-2.0, 5.0), new Coordinate(-2.0, 2.0)};
        lh.createLogicalPolygon("a1", "tipo", c1, null);
        Coordinate[] c2 = new Coordinate[]{new Coordinate(0.0, 3.0), new Coordinate(3.0, 3.0), new Coordinate(1.5, 7.0), new Coordinate(0.0, 3.0)};
        lh.createLogicalPolygon("a2", "tipo", c2, null);
        Coordinate[] c3 = new Coordinate[]{new Coordinate(6.0, 1.0), new Coordinate(7.0, 1.0), new Coordinate(7.0, 2.0), new Coordinate(6.0, 2.0), new Coordinate(6.0, 1.0)};
        lh.createLogicalPolygon("a3", "tipo", c3, null);
        Coordinate[] c4 = new Coordinate[]{new Coordinate(5.0, 1.0), new Coordinate(7.0, 1.0), new Coordinate(7.0, 3.0), new Coordinate(5.0, 1.0)};
        lh.createLogicalPolygon("a4", "tipo", c4, null);
        Coordinate p = new Coordinate(6.5, 2.2);
        List<LocationLogical> locs = lh.getLocationsContaining(p);
        for (LocationLogical ll : locs) {
            System.out.println(ll.getName());
        }
        System.out.println("x-Tree");
        System.out.println(lh.xITree.toString());
        System.out.println("y-Tree");
        System.out.println(lh.yITree.toString());
    }
}

