/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.location;

import com.sun.xacml.Indenter;
import com.sun.xacml.location.LocationHandler;
import com.sun.xacml.location.LocationType;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.io.OutputStream;
import java.io.PrintStream;

public class LocationLogical {
    private boolean isUniverse = false;
    private static LocationLogical universeInstance = null;
    private String name;
    private Geometry geometry;
    private LocationType associatedType;

    public LocationLogical(Geometry g, String n, LocationType assType) {
        this.geometry = g;
        this.name = n;
        this.associatedType = assType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocationLogical getUniverseLocation() {
        if (universeInstance != null) return universeInstance;
        Class<LocationLogical> clazz = LocationLogical.class;
        synchronized (LocationLogical.class) {
            if (universeInstance != null) return universeInstance;
            universeInstance = new LocationLogical(null, "universe", LocationType.getTopInstance());
            LocationLogical.universeInstance.isUniverse = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return universeInstance;
        }
    }

    public String getName() {
        return this.name;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public LocationType getAssociatedType() {
        return this.associatedType;
    }

    public boolean containsPoint(Point point) {
        if (this.isUniverse) {
            return true;
        }
        return this.geometry.contains((Geometry)point);
    }

    public boolean containsPointAtCoords(Coordinate coord) {
        Point p = LocationHandler.getInstance(null).createPoint(coord);
        return this.containsPoint(p);
    }

    public String toString() {
        String ret = this.isUniverse ? "Universe Location" : "Location";
        ret = this.name == null ? "" : String.valueOf(ret) + " name=" + this.name + ",";
        ret = this.geometry == null ? String.valueOf(ret) + " geometry=null," : String.valueOf(ret) + " geometry={" + this.geometry.toString() + "},";
        ret = this.associatedType == null ? String.valueOf(ret) + " associatedType=null," : String.valueOf(ret) + " associatedType={" + this.associatedType.toString() + "}.";
        return ret;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter());
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String startIndent = indenter.makeString();
        out.println(String.valueOf(startIndent) + "<LocationLogical>");
        indenter.in();
        String nextIndent = indenter.makeString();
        out.println(String.valueOf(nextIndent) + "<Name>" + this.name + "</Name>");
        out.println(String.valueOf(nextIndent) + "<AssociatedType>" + this.associatedType.getName() + "</AssociatedType>");
        out.println(String.valueOf(nextIndent) + "<Geometry>" + this.getGeometry().toText() + "</Geometry>");
        out.println(String.valueOf(nextIndent) + "<Universe>" + this.isUniverse + "</Universe>");
        out.println(String.valueOf(startIndent) + "</LocationLogical>");
    }
}

