/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.location;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class LocationNode {
    protected String name;
    private HashMap<String, LocationNode> links;
    public static final int WHITE = 0;
    public static final int GREY = 0;
    public static final int BLACK = 0;
    private int colour = 0;

    public LocationNode(String nodeName) {
        this.name = nodeName;
        this.links = new HashMap();
    }

    public LocationNode(String nodeName, Map<String, LocationNode> connectedTo) {
        this.name = nodeName;
        this.links = new HashMap<String, LocationNode>(connectedTo);
    }

    public String getName() {
        return this.name;
    }

    public Vector<LocationNode> getAdjacents() {
        Vector<LocationNode> adj = new Vector<LocationNode>(this.links.values());
        return adj;
    }

    public boolean isLinkedTo(String typeName) {
        return this.links.containsKey(typeName);
    }

    public boolean addLink(LocationNode to) {
        if (!this.isLinkedTo(to.getName())) {
            this.links.put(to.getName(), to);
            return true;
        }
        return false;
    }

    public boolean removeLink(LocationNode to) {
        return this.links.remove(to.getName()) != null;
    }

    public int getColour() {
        return this.colour;
    }

    public void setColor(int newColour) {
        this.colour = newColour;
    }
}

